/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import zz.com.thoughtworks.xstream.XStream;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.persistence.PersistenceStrategy;

public abstract class AbstractFilePersistenceStrategy
implements PersistenceStrategy {
    private final FilenameFilter filter;
    private final File baseDirectory;
    private final String encoding;
    private final transient XStream xstream;

    public AbstractFilePersistenceStrategy(File file, XStream xStream, String string) {
        this.baseDirectory = file;
        this.xstream = xStream;
        this.encoding = string;
        this.filter = new ValidFilenameFilter();
    }

    protected ConverterLookup getConverterLookup() {
        return this.xstream.getConverterLookup();
    }

    protected Mapper getMapper() {
        return this.xstream.getMapper();
    }

    protected boolean isValid(File file, String string) {
        return string.endsWith(".xml");
    }

    protected abstract Object extractKey(String var1);

    protected abstract String getName(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, Object object) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = this.encoding != null ? new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding) : new OutputStreamWriter(fileOutputStream);
            try {
                this.xstream.toXML(object, outputStreamWriter);
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private File getFile(String string) {
        return new File(this.baseDirectory, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readFile(File file) {
        Object object;
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = this.encoding != null ? new InputStreamReader((InputStream)fileInputStream, this.encoding) : new InputStreamReader(fileInputStream);
        try {
            object = this.xstream.fromXML(inputStreamReader);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)inputStreamReader).close();
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                throw new StreamException(iOException);
            }
        }
        ((Reader)inputStreamReader).close();
        return object;
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.get(object);
        String string = this.getName(object);
        this.writeFile(new File(this.baseDirectory, string), object2);
        return object3;
    }

    public Iterator iterator() {
        return new XmlMapEntriesIterator();
    }

    public int size() {
        return this.baseDirectory.list(this.filter).length;
    }

    public boolean containsKey(Object object) {
        File file = this.getFile(this.getName(object));
        return file.isFile();
    }

    public Object get(Object object) {
        return this.readFile(this.getFile(this.getName(object)));
    }

    public Object remove(Object object) {
        File file = this.getFile(this.getName(object));
        Object object2 = null;
        if (file.isFile()) {
            object2 = this.readFile(file);
            file.delete();
        }
        return object2;
    }

    protected class XmlMapEntriesIterator
    implements Iterator {
        private final File[] files;
        private int position;
        private File current;

        protected XmlMapEntriesIterator() {
            this.files = AbstractFilePersistenceStrategy.this.baseDirectory.listFiles(AbstractFilePersistenceStrategy.this.filter);
            this.position = -1;
            this.current = null;
        }

        public boolean hasNext() {
            return this.position + 1 < this.files.length;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.delete();
        }

        public Object next() {
            return new Map.Entry(){
                private final File file;
                private final Object key;
                {
                    this.file = XmlMapEntriesIterator.this.current = XmlMapEntriesIterator.this.files[++XmlMapEntriesIterator.this.position];
                    this.key = AbstractFilePersistenceStrategy.this.extractKey(this.file.getName());
                }

                public Object getKey() {
                    return this.key;
                }

                public Object getValue() {
                    return AbstractFilePersistenceStrategy.this.readFile(this.file);
                }

                public Object setValue(Object object) {
                    return AbstractFilePersistenceStrategy.this.put(this.key, object);
                }

                public boolean equals(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object object2 = this.getValue();
                    Map.Entry entry = (Map.Entry)object;
                    Object k2 = entry.getKey();
                    Object v2 = entry.getValue();
                    return (this.key == null ? k2 == null : this.key.equals(k2)) && (object2 == null ? v2 == null : this.getValue().equals(entry.getValue()));
                }
            };
        }
    }

    protected class ValidFilenameFilter
    implements FilenameFilter {
        protected ValidFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            return new File(file, string).isFile() && AbstractFilePersistenceStrategy.this.isValid(file, string);
        }
    }
}

