/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.persistence;

import java.io.File;
import zz.com.thoughtworks.xstream.XStream;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.io.xml.DomDriver;
import zz.com.thoughtworks.xstream.persistence.AbstractFilePersistenceStrategy;

public class FilePersistenceStrategy
extends AbstractFilePersistenceStrategy {
    private final String illegalChars;

    public FilePersistenceStrategy(File file) {
        this(file, new XStream(new DomDriver()));
    }

    public FilePersistenceStrategy(File file, XStream xStream) {
        this(file, xStream, "utf-8", "<>?:/\\\"|*%");
    }

    public FilePersistenceStrategy(File file, XStream xStream, String string, String string2) {
        super(file, xStream, string);
        this.illegalChars = string2;
    }

    protected boolean isValid(File file, String string) {
        return super.isValid(file, string) && string.indexOf(64) > 0;
    }

    protected Object extractKey(String string) {
        String string2 = this.unescape(string.substring(0, string.length() - 4));
        if ("null@null".equals(string2)) {
            return null;
        }
        int n2 = string2.indexOf(64);
        if (n2 < 0) {
            ConversionException conversionException = new ConversionException("No valid key");
            conversionException.add("key", string2);
            throw conversionException;
        }
        Class clazz = this.getMapper().realClass(string2.substring(0, n2));
        Converter converter = this.getConverterLookup().lookupConverterForType(clazz);
        if (converter instanceof SingleValueConverter) {
            SingleValueConverter singleValueConverter = (SingleValueConverter)((Object)converter);
            return singleValueConverter.fromString(string2.substring(n2 + 1));
        }
        ConversionException conversionException = new ConversionException("No SingleValueConverter available for key type");
        conversionException.add("key-type", clazz.getName());
        throw conversionException;
    }

    protected String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(37);
        while (n2 >= 0) {
            stringBuffer.append(string.substring(0, n2));
            int n3 = Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
            stringBuffer.append((char)n3);
            string = string.substring(n2 + 3);
            n2 = string.indexOf(37);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String getName(Object object) {
        if (object == null) {
            return "null@null.xml";
        }
        Class<?> clazz = object.getClass();
        Converter converter = this.getConverterLookup().lookupConverterForType(clazz);
        if (converter instanceof SingleValueConverter) {
            SingleValueConverter singleValueConverter = (SingleValueConverter)((Object)converter);
            return this.getMapper().serializedClass(clazz) + '@' + this.escape(singleValueConverter.toString(object)) + ".xml";
        }
        ConversionException conversionException = new ConversionException("No SingleValueConverter available for key type");
        conversionException.add("key-type", clazz.getName());
        throw conversionException;
    }

    protected String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= ' ' && this.illegalChars.indexOf(c2) < 0) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append("%" + Integer.toHexString(c2).toUpperCase());
        }
        return stringBuffer.toString();
    }
}

