/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.SeekableBlockCipher;
import zz.de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.org.bouncycastle.crypto.Mac;

@NotThreadSafe
public abstract class CipherReadOnlyFile
extends DecoratingReadOnlyFile {
    private static final long INVALID = Long.MIN_VALUE;
    private long start;
    private long length;
    private long pos;
    private long bufferStart = Long.MIN_VALUE;
    private byte[] buffer;
    @Nullable
    private SeekableBlockCipher cipher;
    private long blockStart = Long.MIN_VALUE;
    private byte[] block;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected CipherReadOnlyFile(@Nullable @WillCloseWhenClosed ReadOnlyFile readOnlyFile) {
        super(readOnlyFile);
    }

    protected final void init(SeekableBlockCipher seekableBlockCipher, long l2, long l3) throws IOException {
        if (null == this.delegate) {
            throw new IllegalStateException();
        }
        if (null != this.cipher) {
            throw new IllegalStateException();
        }
        this.cipher = seekableBlockCipher;
        if (null == this.cipher) {
            throw new IllegalArgumentException();
        }
        this.start = l2;
        if (0L > this.start) {
            throw new IllegalArgumentException();
        }
        this.length = l3;
        if (0L > this.length) {
            throw new IllegalArgumentException();
        }
        int n2 = seekableBlockCipher.getBlockSize();
        this.block = new byte[n2];
        this.buffer = new byte[8192 / n2 * n2];
        assert (this.buffer.length % n2 == 0);
    }

    private void checkOpen() throws IOException {
        if (null == this.cipher) {
            throw new IOException("cipher read only file is not in open state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] computeMac(Mac mac) throws IOException {
        long l2 = this.getFilePointer();
        try {
            long l3 = this.length;
            int n2 = this.buffer.length;
            this.pos = 0L;
            while (this.pos < l3) {
                this.positionBuffer();
                int n3 = (int)Math.min((long)n2, l3 - this.bufferStart);
                assert (0 < n3);
                mac.update(this.buffer, 0, n3);
                this.pos += (long)n3;
            }
            byte[] byArray = new byte[mac.getMacSize()];
            int n4 = mac.doFinal(byArray, 0);
            assert (n4 == byArray.length);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this.seek(l2);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.pos >= this.length) {
            return -1;
        }
        this.positionBlock();
        return this.block[(int)(this.pos++ % (long)this.block.length)] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 <= 0) {
            return 0;
        }
        long l2 = this.length;
        if (this.getFilePointer() >= l2) {
            return -1;
        }
        int n5 = n2 + n3;
        if ((n2 | n3 | n5 | byArray.length - n5) < 0) {
            throw new IndexOutOfBoundsException();
        }
        n5 = 0;
        int n6 = this.block.length;
        this.positionBlock();
        if (this.pos != this.blockStart) {
            assert (this.pos % (long)n6 != 0L);
            n4 = (int)(this.pos - this.blockStart);
            int n7 = Math.min(n3, n6 - n4);
            n7 = (int)Math.min((long)n7, l2 - this.pos);
            assert (n7 > 0);
            System.arraycopy(this.block, n4, byArray, n2, n7);
            n5 += n7;
            this.pos += (long)n7;
        }
        if (n5 < n3 && this.pos < l2) {
            SeekableBlockCipher seekableBlockCipher = this.cipher;
            byte[] byArray2 = this.buffer;
            long l3 = this.pos / (long)n6;
            while (n5 + n6 <= n3 && this.pos + (long)n6 <= l2) {
                assert (this.pos % (long)n6 == 0L);
                this.positionBuffer();
                seekableBlockCipher.setBlockCounter(l3++);
                int n8 = (int)(this.pos - this.bufferStart);
                int n9 = seekableBlockCipher.processBlock(byArray2, n8, byArray, n2 + n5);
                assert (n9 == n6);
                n5 += n9;
                this.pos += (long)n9;
            }
        }
        if (n5 < n3 && this.pos < l2) {
            assert (this.pos % (long)n6 == 0L);
            this.positionBlock();
            n4 = (int)(this.pos - this.blockStart);
            int n10 = Math.min(n3 - n5, n6 - n4);
            n10 = (int)Math.min((long)n10, l2 - this.pos);
            assert (n10 > 0);
            System.arraycopy(this.block, n4, byArray, n2 + n5, n10);
            n5 += n10;
            this.pos += (long)n10;
        }
        return n5;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.checkOpen();
        return this.pos;
    }

    @Override
    public void seek(long l2) throws IOException {
        this.checkOpen();
        if (l2 < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        if (l2 > this.length) {
            throw new IOException("file pointer (" + l2 + ") is larger than file length (" + this.length + ")");
        }
        this.pos = l2;
    }

    @Override
    public long length() throws IOException {
        this.checkOpen();
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.cipher = null;
        this.delegate.close();
    }

    private void positionBlock() throws IOException {
        long l2;
        byte[] byArray = this.block;
        int n2 = byArray.length;
        long l3 = this.blockStart;
        long l4 = this.pos;
        if (l3 <= l4 && l4 < (l2 = l3 + (long)n2)) {
            return;
        }
        SeekableBlockCipher seekableBlockCipher = this.cipher;
        assert (null != seekableBlockCipher);
        this.positionBuffer();
        long l5 = l4 / (long)n2;
        seekableBlockCipher.setBlockCounter(l5);
        this.blockStart = l3 = l5 * (long)n2;
        int n3 = (int)(l3 - this.bufferStart);
        int n4 = seekableBlockCipher.processBlock(this.buffer, n3, byArray, 0);
        assert (n4 == n2);
    }

    private void positionBuffer() throws IOException {
        byte[] byArray = this.buffer;
        int n2 = byArray.length;
        long l2 = this.pos;
        long l3 = this.bufferStart;
        long l4 = l3 + (long)n2;
        if (l3 <= l2 && l2 < l4) {
            return;
        }
        try {
            int n3;
            ReadOnlyFile readOnlyFile = this.delegate;
            this.bufferStart = l3 = l2 / (long)n2 * (long)n2;
            if (l3 != l4) {
                readOnlyFile.seek(this.start + l3);
            }
            int n4 = 0;
            while ((n3 = readOnlyFile.read(byArray, n4, n2 - n4)) >= 0 && (n4 += n3) < n2) {
            }
        }
        catch (IOException iOException) {
            this.bufferStart = Long.MIN_VALUE;
            throw iOException;
        }
    }
}

