/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.crypto;

import zz.de.schlichtherle.truezip.crypto.SeekableBlockCipher;
import zz.org.bouncycastle.crypto.BlockCipher;
import zz.org.bouncycastle.crypto.CipherParameters;
import zz.org.bouncycastle.crypto.DataLengthException;
import zz.org.bouncycastle.crypto.params.ParametersWithIV;

public class SICSeekableBlockCipher
implements SeekableBlockCipher {
    protected final BlockCipher cipher;
    protected final int blockSize;
    protected long blockCounter;
    protected final byte[] IV;
    protected final byte[] cipherIn;
    protected final byte[] cipherOut;

    public SICSeekableBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.cipherIn = new byte[this.blockSize];
        this.cipherOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
        this.reset();
        this.cipher.init(true, parametersWithIV.getParameters());
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        assert (this.blockSize == this.cipher.getBlockSize());
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4;
        this.incCounter();
        this.cipher.processBlock(this.cipherIn, 0, this.cipherOut, 0);
        int n5 = n4 = this.blockSize;
        n2 += n5;
        n3 += n5;
        while (n5 > 0) {
            byArray2[--n3] = (byte)(byArray[--n2] ^ this.cipherOut[--n5]);
        }
        return n4;
    }

    private void incCounter() {
        int n2 = this.blockSize;
        long l2 = this.blockCounter++;
        int n3 = n2;
        while (--n3 >= 0) {
            this.cipherIn[n3] = (byte)(l2 += (long)(this.IV[n3] & 0xFF));
            l2 >>>= 8;
        }
    }

    @Override
    public void setBlockCounter(long l2) {
        this.blockCounter = l2;
    }

    @Override
    public long getBlockCounter() {
        return this.blockCounter;
    }

    public void reset() {
        this.cipher.reset();
        this.blockCounter = 0L;
    }
}

