/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.fs.FsAbstractCompositeDriver;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsDriverProvider;
import zz.de.schlichtherle.truezip.fs.FsScheme;
import zz.de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import zz.de.schlichtherle.truezip.fs.spi.FsDriverService;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.util.SuffixSet;

@Immutable
public final class TArchiveDetector
extends FsAbstractCompositeDriver {
    public static final TArchiveDetector NULL = new TArchiveDetector("");
    public static final TArchiveDetector ALL = new TArchiveDetector(null);
    private final SuffixSet suffixes;
    private final Map<FsScheme, FsDriver> drivers;

    private static SuffixSet extensions(FsDriverProvider fsDriverProvider) {
        if (fsDriverProvider instanceof TArchiveDetector) {
            return new SuffixSet(((TArchiveDetector)fsDriverProvider).suffixes);
        }
        Map<FsScheme, FsDriver> map = fsDriverProvider.get();
        SuffixSet suffixSet = new SuffixSet();
        for (Map.Entry<FsScheme, FsDriver> entry : map.entrySet()) {
            if (!entry.getValue().isFederated()) continue;
            suffixSet.add(entry.getKey().toString());
        }
        return suffixSet;
    }

    public TArchiveDetector(@CheckForNull String string) {
        this((FsDriverProvider)FsDriverLocator.SINGLETON, string);
    }

    public TArchiveDetector(FsDriverProvider fsDriverProvider, @CheckForNull String string) {
        SuffixSet suffixSet;
        SuffixSet suffixSet2 = TArchiveDetector.extensions(fsDriverProvider);
        if (null == string) {
            suffixSet = suffixSet2;
        } else {
            suffixSet = new SuffixSet(string);
            if (suffixSet.retainAll(suffixSet2)) {
                suffixSet = new SuffixSet(string);
                suffixSet.removeAll(suffixSet2);
                assert (!suffixSet.isEmpty());
                throw new IllegalArgumentException("\"" + suffixSet + "\" (no archive driver installed for these extensions)");
            }
        }
        this.suffixes = suffixSet;
        this.drivers = fsDriverProvider.get();
    }

    public TArchiveDetector(String string, @CheckForNull FsDriver fsDriver) {
        this(NULL, string, fsDriver);
    }

    public TArchiveDetector(FsDriverProvider fsDriverProvider, String string, @CheckForNull FsDriver fsDriver) {
        this(fsDriverProvider, new Object[][]{{string, fsDriver}});
    }

    public TArchiveDetector(FsDriverProvider fsDriverProvider, Object[][] objectArray) {
        this(fsDriverProvider, FsDriverService.newMap(objectArray));
    }

    public TArchiveDetector(FsDriverProvider fsDriverProvider, Map<FsScheme, FsDriver> map) {
        SuffixSet suffixSet = TArchiveDetector.extensions(fsDriverProvider);
        Map<FsScheme, FsDriver> map2 = fsDriverProvider.get();
        HashMap<FsScheme, FsDriver> hashMap = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity(map2.size() + map.size()));
        hashMap.putAll(map2);
        for (Map.Entry<FsScheme, FsDriver> entry : map.entrySet()) {
            FsScheme fsScheme = entry.getKey();
            FsDriver fsDriver = entry.getValue();
            if (null != fsDriver) {
                suffixSet.add(fsScheme.toString());
                hashMap.put(fsScheme, fsDriver);
                continue;
            }
            suffixSet.remove(fsScheme.toString());
        }
        this.suffixes = suffixSet;
        this.drivers = Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }

    @CheckForNull
    public FsScheme getScheme(String string) {
        string = string.replace('/', File.separatorChar);
        int n2 = string.lastIndexOf(File.separatorChar) + 1;
        string = string.substring(n2);
        int n3 = string.length();
        n2 = 0;
        while (0 < (n2 = string.indexOf(46, n2) + 1) && n2 < n3) {
            String string2 = string.substring(n2);
            if (!this.suffixes.contains(string2)) continue;
            try {
                return new FsScheme(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return null;
    }

    public String toString() {
        return this.suffixes.toString();
    }
}

