/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TConfig;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsPath;
import zz.de.schlichtherle.truezip.io.Paths;
import zz.de.schlichtherle.truezip.socket.IOSocket;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;

@Immutable
final class TBIO {
    private TBIO() {
    }

    static void mv(File file, File file2, TArchiveDetector tArchiveDetector) throws IOException {
        TBIO.checkContains(file, file2);
        if (file2.exists()) {
            throw new IOException(file2 + " (destination exists already)");
        }
        TBIO.mv0(file, file2, tArchiveDetector);
    }

    private static void mv0(File file, File file2, TArchiveDetector tArchiveDetector) throws IOException {
        if (file.isDirectory()) {
            boolean bl2;
            long l2 = file.lastModified();
            boolean bl3 = file instanceof TFile && null != ((TFile)file).getInnerArchive();
            boolean bl4 = file2 instanceof TFile && null != ((TFile)file2).getInnerArchive();
            boolean bl5 = bl2 = bl3 && 0L >= l2;
            if (!(bl2 && bl4 && TConfig.get().isLenient() || file2.mkdir() || file2.isDirectory())) {
                throw new IOException(file2 + " (not a directory)");
            }
            Object[] objectArray = file.list();
            if (null == objectArray) {
                throw new IOException(file2 + " (cannot list directory)");
            }
            if (!bl3 && bl4) {
                Arrays.sort(objectArray);
            }
            for (Object object : objectArray) {
                TBIO.mv0(new TFile(file, (String)object, tArchiveDetector), new TFile(file2, (String)object, tArchiveDetector), tArchiveDetector);
            }
            if (!bl2 && !file2.setLastModified(l2)) {
                throw new IOException(file2 + " (cannot set last modification time)");
            }
        } else if (file.isFile()) {
            if (file2.exists() && !file2.isFile()) {
                throw new IOException(file2 + " (not a file)");
            }
            TBIO.cp0(true, file, file2);
        } else {
            if (file.exists()) {
                throw new IOException(file + " (cannot move special file)");
            }
            throw new IOException(file + " (missing file)");
        }
        if (!file.delete()) {
            throw new IOException(file + " (cannot delete)");
        }
    }

    static void cp_r(boolean bl2, File file, File file2, TArchiveDetector tArchiveDetector, TArchiveDetector tArchiveDetector2) throws IOException {
        TBIO.checkContains(file, file2);
        TBIO.cp_r0(bl2, file, file2, tArchiveDetector, tArchiveDetector2);
    }

    private static void cp_r0(boolean bl2, File file, File file2, TArchiveDetector tArchiveDetector, TArchiveDetector tArchiveDetector2) throws IOException {
        if (file.isDirectory()) {
            boolean bl3;
            long l2 = file.lastModified();
            boolean bl4 = file instanceof TFile && null != ((TFile)file).getInnerArchive();
            boolean bl5 = file2 instanceof TFile && null != ((TFile)file2).getInnerArchive();
            boolean bl6 = bl3 = bl4 && 0L >= l2;
            if (!(bl3 && bl5 && TConfig.get().isLenient() || file2.mkdir() || file2.isDirectory())) {
                throw new IOException(file2 + " (not a directory)");
            }
            Object[] objectArray = file.list();
            if (null == objectArray) {
                throw new IOException(file2 + " (cannot list directory)");
            }
            if (!bl4 && bl5) {
                Arrays.sort(objectArray);
            }
            for (Object object : objectArray) {
                TBIO.cp_r0(bl2, new TFile(file, (String)object, tArchiveDetector), new TFile(file2, (String)object, tArchiveDetector2), tArchiveDetector, tArchiveDetector2);
            }
            if (bl2 && !bl3 && !file2.setLastModified(l2)) {
                throw new IOException(file2 + " (cannot set last modification time)");
            }
        } else if (file.isFile()) {
            if (file2.exists() && !file2.isFile()) {
                throw new IOException(file2 + " (not a file)");
            }
            TBIO.cp0(bl2, file, file2);
        } else {
            if (file.exists()) {
                throw new IOException(file + " (cannot copy special file)");
            }
            throw new IOException(file + " (missing file)");
        }
    }

    static void cp(boolean bl2, File file, File file2) throws IOException {
        TBIO.checkContains(file, file2);
        TBIO.cp0(bl2, file, file2);
    }

    private static void cp0(boolean bl2, File file, File file2) throws IOException {
        TConfig tConfig = TConfig.get();
        InputSocket<?> inputSocket = TBIO.getInputSocket(file, tConfig.getInputPreferences());
        OutputSocket<?> outputSocket = TBIO.getOutputSocket(file2, tConfig.getOutputPreferences(), bl2 ? (Entry)inputSocket.getLocalTarget() : null);
        IOSocket.copy(inputSocket, outputSocket);
    }

    static void rm_r(File file, TArchiveDetector tArchiveDetector) throws IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (null == stringArray) {
                throw new IOException(file + " (cannot list directory)");
            }
            for (String string : stringArray) {
                TBIO.rm_r(new TFile(file, string, tArchiveDetector), tArchiveDetector);
            }
        }
        TFile.rm(file);
    }

    private static void checkContains(File file, File file2) throws IOException {
        if (Paths.contains(file.getAbsolutePath(), file2.getAbsolutePath(), File.separatorChar)) {
            throw new IOException(file2 + " (contained in " + file + ")");
        }
    }

    static InputSocket<?> getInputSocket(File file, BitField<FsInputOption> bitField) {
        Comparable<File> comparable;
        TFile tFile;
        if (file instanceof TFile && null != (tFile = ((TFile)(comparable = (TFile)file)).getInnerArchive())) {
            return tFile.getController().getInputSocket(((TFile)comparable).getInnerFsEntryName(), bitField);
        }
        comparable = new FsPath(file);
        return TConfig.get().getFsManager().getController(((FsPath)comparable).getMountPoint(), TBIO.getDetector(file)).getInputSocket(((FsPath)comparable).getEntryName(), bitField);
    }

    static OutputSocket<?> getOutputSocket(File file, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        Comparable<File> comparable;
        TFile tFile;
        if (file instanceof TFile && null != (tFile = ((TFile)(comparable = (TFile)file)).getInnerArchive())) {
            return tFile.getController().getOutputSocket(((TFile)comparable).getInnerFsEntryName(), bitField, entry);
        }
        comparable = new FsPath(file);
        return TConfig.get().getFsManager().getController(((FsPath)comparable).getMountPoint(), TBIO.getDetector(file)).getOutputSocket(((FsPath)comparable).getEntryName(), bitField.clear(FsOutputOption.CREATE_PARENTS), entry);
    }

    private static TArchiveDetector getDetector(File file) {
        return file instanceof TFile ? ((TFile)file).getArchiveDetector() : TConfig.get().getArchiveDetector();
    }
}

