/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.swing.Icon;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.file.ExpertFeature;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TBIO;
import zz.de.schlichtherle.truezip.file.TConfig;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.de.schlichtherle.truezip.file.TFileOutputStream;
import zz.de.schlichtherle.truezip.file.TVFS;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsPath;
import zz.de.schlichtherle.truezip.fs.FsScheme;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncOptions;
import zz.de.schlichtherle.truezip.fs.FsUriModifier;
import zz.de.schlichtherle.truezip.io.Paths;
import zz.de.schlichtherle.truezip.io.Streams;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.de.schlichtherle.truezip.util.UriBuilder;

@Immutable
public final class TFile
extends File {
    private static final long serialVersionUID = 3617072259051821745L;
    private static final String UNC_PREFIX = separator + separator;
    private static final Set<File> ROOTS = Collections.unmodifiableSet(new TreeSet<File>(Arrays.asList(TFile.listRoots())));
    private static final File CURRENT_DIRECTORY = new File(".");
    private transient File file;
    private transient TArchiveDetector detector;
    @CheckForNull
    private transient TFile innerArchive;
    @CheckForNull
    private transient TFile enclArchive;
    @CheckForNull
    private transient FsEntryName enclEntryName;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private volatile transient FsController<?> controller;

    public TFile(File file) {
        this(file, (TArchiveDetector)null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(File file, @CheckForNull TArchiveDetector tArchiveDetector) {
        super(file.getPath());
        if (file instanceof TFile) {
            TFile tFile = (TFile)file;
            this.file = tFile.file;
            this.detector = tFile.detector;
            this.enclArchive = tFile.enclArchive;
            this.enclEntryName = tFile.enclEntryName;
            this.innerArchive = tFile.isArchive() ? this : tFile.innerArchive;
            this.controller = tFile.controller;
        } else {
            this.file = file;
            this.detector = null != tArchiveDetector ? tArchiveDetector : TConfig.get().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(String string) {
        this(string, (TArchiveDetector)null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(String string, @CheckForNull TArchiveDetector tArchiveDetector) {
        super(string);
        this.file = new File(string);
        this.detector = null != tArchiveDetector ? tArchiveDetector : TConfig.get().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull String string, String string2) {
        this(string, string2, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(@CheckForNull String string, String string2, @CheckForNull TArchiveDetector tArchiveDetector) {
        super(string, string2);
        this.file = new File(string, string2);
        this.detector = null != tArchiveDetector ? tArchiveDetector : TConfig.get().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull File file, String string) {
        this(file, string, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(@CheckForNull File file, String string, @CheckForNull TArchiveDetector tArchiveDetector) {
        super(file, string);
        this.file = new File(file, string);
        if (file instanceof TFile) {
            TFile tFile = (TFile)file;
            this.detector = null != tArchiveDetector ? tArchiveDetector : tFile.detector;
            this.scan(tFile);
        } else {
            this.detector = null != tArchiveDetector ? tArchiveDetector : TConfig.get().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(URI uRI) {
        this(FsPath.create(uRI, FsUriModifier.CANONICALIZE), null);
    }

    public TFile(FsPath fsPath) {
        this(fsPath, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(FsPath fsPath, @CheckForNull TArchiveDetector tArchiveDetector) {
        super(fsPath.toHierarchicalUri());
        this.parse(fsPath, null != tArchiveDetector ? tArchiveDetector : TConfig.get().getArchiveDetector());
    }

    private void parse(FsPath fsPath, TArchiveDetector tArchiveDetector) {
        this.file = new File(super.getPath());
        this.detector = tArchiveDetector;
        FsMountPoint fsMountPoint = fsPath.getMountPoint();
        FsPath fsPath2 = fsMountPoint.getPath();
        if (null == fsPath2) {
            assert (!fsPath.toUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            FsEntryName fsEntryName = fsPath.getEntryName();
            if (fsEntryName.isRoot()) {
                assert (fsPath.toUri().isOpaque());
                if (fsPath2.toUri().isOpaque()) {
                    this.enclArchive = new TFile(fsPath2.getMountPoint(), tArchiveDetector);
                    this.enclEntryName = fsPath2.getEntryName();
                } else {
                    this.enclArchive = null;
                    this.enclEntryName = null;
                }
                this.innerArchive = this;
                this.controller = this.getController(fsMountPoint);
            } else {
                assert (fsPath.toUri().isOpaque());
                this.enclArchive = new TFile(fsMountPoint, tArchiveDetector);
                this.enclEntryName = fsEntryName;
                this.innerArchive = this.enclArchive;
            }
        }
        assert (this.invariants());
    }

    private TFile(FsMountPoint fsMountPoint, TArchiveDetector tArchiveDetector) {
        super(fsMountPoint.toHierarchicalUri());
        this.file = new File(super.getPath());
        this.detector = tArchiveDetector;
        FsPath fsPath = fsMountPoint.getPath();
        if (null == fsPath) {
            assert (!fsMountPoint.toUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            assert (fsMountPoint.toUri().isOpaque());
            if (fsPath.toUri().isOpaque()) {
                this.enclArchive = new TFile(fsPath.getMountPoint(), tArchiveDetector);
                this.enclEntryName = fsPath.getEntryName();
            } else {
                this.enclArchive = null;
                this.enclEntryName = null;
            }
            this.innerArchive = this;
            this.controller = this.getController(fsMountPoint);
        }
        assert (this.invariants());
    }

    private TFile(File file, @CheckForNull TFile tFile, TArchiveDetector tArchiveDetector) {
        super(file.getPath());
        this.file = file;
        String string = file.getPath();
        if (null != tFile) {
            int n2 = tFile.getPath().length();
            if (string.length() == n2) {
                this.detector = tFile.detector;
                this.enclArchive = tFile.enclArchive;
                this.enclEntryName = tFile.enclEntryName;
                this.innerArchive = this;
                this.controller = tFile.controller;
            } else {
                this.detector = tArchiveDetector;
                this.innerArchive = this.enclArchive = tFile;
                try {
                    this.enclEntryName = new FsEntryName(new UriBuilder().path(string.substring(n2 + 1).replace(separatorChar, '/')).getUri(), FsUriModifier.CANONICALIZE);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new AssertionError((Object)uRISyntaxException);
                }
            }
        } else {
            this.detector = tArchiveDetector;
        }
        assert (this.invariants());
    }

    private void scan(@CheckForNull TFile tFile) {
        String string = super.getPath();
        assert (tFile == null || string.startsWith(tFile.getPath()));
        assert (this.file.getPath().equals(string));
        assert (null != this.detector);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        this.scan(tFile, this.detector, 0, string, stringBuilder, new Paths.Splitter(separatorChar, false));
        try {
            this.enclEntryName = 0 >= stringBuilder.length() ? null : new FsEntryName(new UriBuilder().path(stringBuilder.toString()).getUri(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    private void scan(@CheckForNull TFile tFile, TArchiveDetector tArchiveDetector, int n2, String string, StringBuilder stringBuilder, Paths.Splitter splitter) {
        if (string == null) {
            assert (null == this.enclArchive);
            stringBuilder.setLength(0);
            return;
        }
        splitter.split(string);
        String string2 = splitter.getParentPath();
        String string3 = splitter.getMemberName();
        if (0 != string3.length() && !".".equals(string3)) {
            if ("..".equals(string3)) {
                ++n2;
            } else if (0 < n2) {
                --n2;
            } else {
                int n3;
                if (null != tFile) {
                    int n4;
                    n3 = string.length();
                    if (n3 == (n4 = tFile.getPath().length())) {
                        this.enclArchive = tFile.innerArchive;
                        if (!tFile.isArchive()) {
                            if (tFile.isEntry()) {
                                assert (null != tFile.enclEntryName);
                                if (0 < stringBuilder.length()) {
                                    stringBuilder.insert(0, '/');
                                    stringBuilder.insert(0, tFile.enclEntryName.getPath());
                                } else {
                                    assert (this.enclArchive == tFile.enclArchive);
                                    stringBuilder.append(tFile.enclEntryName.getPath());
                                }
                            } else {
                                assert (null == this.enclArchive);
                                stringBuilder.setLength(0);
                            }
                        } else if (0 >= stringBuilder.length()) {
                            assert (this.enclArchive == tFile);
                            this.innerArchive = this;
                            this.enclArchive = tFile.enclArchive;
                            if (tFile.enclEntryName != null) {
                                stringBuilder.append(tFile.enclEntryName.getPath());
                            }
                        }
                        if (this != this.innerArchive) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (n3 < n4) {
                        tArchiveDetector = tFile.detector;
                        tFile = tFile.enclArchive;
                    }
                }
                int n5 = n3 = null != tArchiveDetector.getScheme(string) ? 1 : 0;
                if (0 < stringBuilder.length()) {
                    if (n3 != 0) {
                        this.enclArchive = new TFile(string, tArchiveDetector);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    stringBuilder.insert(0, '/');
                    stringBuilder.insert(0, string3);
                } else {
                    if (n3 != 0) {
                        this.innerArchive = this;
                    }
                    stringBuilder.append(string3);
                }
            }
        }
        this.scan(tFile, tArchiveDetector, n2, string2, stringBuilder, splitter);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.getAbsoluteFile();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.toURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.parse(FsPath.create((URI)objectInputStream.readObject(), FsUriModifier.CANONICALIZE), TConfig.get().getArchiveDetector());
    }

    private boolean invariants() {
        File file = this.file;
        TFile tFile = this.innerArchive;
        TFile tFile2 = this.enclArchive;
        FsEntryName fsEntryName = this.enclEntryName;
        assert (null != file);
        assert (!(file instanceof TFile));
        assert (file.getPath().equals(super.getPath()));
        assert (null != this.detector);
        assert (null != tFile == (this.getInnerEntryName() != null));
        assert (null != tFile2 == (fsEntryName != null));
        assert (this != tFile2);
        assert (this == tFile ^ (tFile == tFile2 && null == this.controller));
        assert (null == tFile2 || Paths.contains(tFile2.getPath(), file.getParentFile().getPath(), separatorChar) && !fsEntryName.toString().isEmpty());
        return true;
    }

    @Deprecated
    public static void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        TVFS.sync(bitField);
    }

    @Deprecated
    public static void sync(TFile tFile, BitField<FsSyncOption> bitField) throws FsSyncException {
        if (!tFile.isArchive()) {
            throw new IllegalArgumentException(tFile + " (not an archive file)");
        }
        if (null != tFile.getEnclArchive()) {
            throw new IllegalArgumentException(tFile + " (not a top level archive file)");
        }
        TVFS.sync(tFile, bitField);
    }

    @Deprecated
    public static void umount() throws FsSyncException {
        TVFS.umount();
    }

    @Deprecated
    public static void umount(boolean bl2) throws FsSyncException {
        TVFS.sync(BitField.of(FsSyncOption.CLEAR_CACHE).set(FsSyncOption.FORCE_CLOSE_INPUT, bl2).set(FsSyncOption.FORCE_CLOSE_OUTPUT, bl2));
    }

    @Deprecated
    public static void umount(boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws FsSyncException {
        TVFS.sync(BitField.of(FsSyncOption.CLEAR_CACHE).set(FsSyncOption.WAIT_CLOSE_INPUT, bl2).set(FsSyncOption.FORCE_CLOSE_INPUT, bl3).set(FsSyncOption.WAIT_CLOSE_OUTPUT, bl4).set(FsSyncOption.FORCE_CLOSE_OUTPUT, bl5));
    }

    @Deprecated
    public static void umount(TFile tFile) throws FsSyncException {
        TFile.sync(tFile, FsSyncOptions.UMOUNT);
    }

    @Deprecated
    public static void umount(TFile tFile, boolean bl2) throws FsSyncException {
        TFile.sync(tFile, BitField.of(FsSyncOption.CLEAR_CACHE).set(FsSyncOption.FORCE_CLOSE_INPUT, bl2).set(FsSyncOption.FORCE_CLOSE_OUTPUT, bl2));
    }

    @Deprecated
    public static void umount(TFile tFile, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws FsSyncException {
        TFile.sync(tFile, BitField.of(FsSyncOption.CLEAR_CACHE).set(FsSyncOption.WAIT_CLOSE_INPUT, bl2).set(FsSyncOption.FORCE_CLOSE_INPUT, bl3).set(FsSyncOption.WAIT_CLOSE_OUTPUT, bl4).set(FsSyncOption.FORCE_CLOSE_OUTPUT, bl5));
    }

    @Deprecated
    public static boolean isLenient() {
        return TConfig.get().isLenient();
    }

    @Deprecated
    public static void setLenient(boolean bl2) {
        TConfig.get().setLenient(bl2);
    }

    @Deprecated
    public static TArchiveDetector getDefaultArchiveDetector() {
        return TConfig.get().getArchiveDetector();
    }

    @Deprecated
    public static void setDefaultArchiveDetector(TArchiveDetector tArchiveDetector) {
        TConfig.get().setArchiveDetector(tArchiveDetector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile toNonArchiveFile() {
        return this.isArchive() ? new TFile((File)this.getParentFile(), this.getName(), TArchiveDetector.NULL) : this;
    }

    @Nullable
    public TFile getNonArchivedParentFile() {
        TFile tFile = this.enclArchive;
        return null != tFile ? tFile.getNonArchivedParentFile() : this.getParentFile();
    }

    @Override
    @Nullable
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    @Nullable
    public TFile getParentFile() {
        File file = this.file.getParentFile();
        if (file == null) {
            return null;
        }
        TFile tFile = this.enclArchive;
        if (null != tFile && tFile.getPath().length() == file.getPath().length()) {
            assert (tFile.getPath().equals(file.getPath()));
            return tFile;
        }
        return new TFile(file, tFile, this.detector);
    }

    @Override
    public TFile getAbsoluteFile() {
        String string = this.getAbsolutePath();
        return string.equals(this.getPath()) ? this : new TFile(string, this.detector);
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public TFile getNormalizedAbsoluteFile() {
        String string = this.getNormalizedAbsolutePath();
        return string.equals(this.getPath()) ? this : new TFile(string, this.detector);
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize(this.getAbsolutePath(), separatorChar);
    }

    public TFile getNormalizedFile() {
        String string = this.getNormalizedPath();
        return string.equals(this.getPath()) ? this : new TFile(string, this.detector);
    }

    public String getNormalizedPath() {
        return Paths.normalize(this.getPath(), separatorChar);
    }

    @Override
    public TFile getCanonicalFile() throws IOException {
        String string = this.getCanonicalPath();
        return string.equals(this.getPath()) ? this : new TFile(string, this.detector);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public TFile getCanOrAbsFile() {
        String string = this.getCanOrAbsPath();
        return string.equals(this.getPath()) ? this : new TFile(string, this.detector);
    }

    public String getCanOrAbsPath() {
        try {
            return this.getCanonicalPath();
        }
        catch (IOException iOException) {
            return Paths.normalize(this.getAbsolutePath(), separatorChar);
        }
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public boolean isArchive() {
        return this == this.innerArchive;
    }

    public boolean isEntry() {
        return this.enclEntryName != null;
    }

    @CheckForNull
    public TFile getInnerArchive() {
        return this.innerArchive;
    }

    @Nullable
    public String getInnerEntryName() {
        FsEntryName fsEntryName;
        return this == this.innerArchive ? FsEntryName.ROOT.getPath() : (null == (fsEntryName = this.enclEntryName) ? null : fsEntryName.getPath());
    }

    @Nullable
    FsEntryName getInnerFsEntryName() {
        return this == this.innerArchive ? FsEntryName.ROOT : this.enclEntryName;
    }

    @CheckForNull
    public TFile getEnclArchive() {
        return this.enclArchive;
    }

    @Nullable
    public String getEnclEntryName() {
        return null == this.enclEntryName ? null : this.enclEntryName.getPath();
    }

    @Nullable
    FsEntryName getEnclFsEntryName() {
        return this.enclEntryName;
    }

    public boolean isTopLevelArchive() {
        return this.getTopLevelArchive() == this;
    }

    @Nullable
    public TFile getTopLevelArchive() {
        TFile tFile = this.enclArchive;
        return null != tFile ? tFile.getTopLevelArchive() : this.innerArchive;
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    @Nullable
    FsController<?> getController() {
        FsMountPoint fsMountPoint;
        FsController<?> fsController = this.controller;
        if (this != this.innerArchive || null != fsController) {
            return fsController;
        }
        File file = this.file;
        String string = Paths.normalize(file.getPath(), separatorChar);
        FsScheme fsScheme = this.detector.getScheme(string);
        if (null == fsScheme) {
            throw new ServiceConfigurationError("Unknown file system scheme for path \"" + string + "\"! Check run-time class path configuration.");
        }
        try {
            TFile tFile = this.enclArchive;
            FsEntryName fsEntryName = this.enclEntryName;
            assert (null != tFile == (null != fsEntryName));
            fsMountPoint = new FsMountPoint(fsScheme, null == tFile ? new FsPath(file) : new FsPath(((FsModel)tFile.getController().getModel()).getMountPoint(), fsEntryName));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
        this.controller = this.getController(fsMountPoint);
        return this.controller;
    }

    private FsController<?> getController(FsMountPoint fsMountPoint) {
        return TConfig.get().getFsManager().getController(fsMountPoint, this.detector);
    }

    public boolean isParentOf(File file) {
        String string = this.getAbsolutePath();
        String string2 = file.getAbsoluteFile().getParent();
        return string2 != null ? Paths.contains(string, string2, separatorChar) : false;
    }

    @Override
    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    public boolean contains(File file) {
        return TFile.contains(this, file);
    }

    public static boolean contains(File file, File file2) {
        return Paths.contains(file.getAbsolutePath(), file2.getAbsolutePath(), separatorChar);
    }

    public boolean isFileSystemRoot() {
        TFile tFile = this.getCanOrAbsFile();
        return ROOTS.contains(tFile) || TFile.isUNC(tFile.getPath());
    }

    public boolean isUNC() {
        return TFile.isUNC(this.getCanOrAbsPath());
    }

    private static boolean isUNC(String string) {
        return string.startsWith(UNC_PREFIX) && string.indexOf(separatorChar, 2) > 2;
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.file.equals(object);
    }

    @Override
    public int compareTo(File file) {
        return this.file.compareTo(file);
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        return null != this.innerArchive ? this.toURI().toURL() : this.file.toURL();
    }

    @Override
    public URI toURI() {
        try {
            if (this == this.innerArchive) {
                FsScheme fsScheme = this.getScheme();
                if (null != this.enclArchive) {
                    assert (null != this.enclEntryName);
                    return new FsMountPoint(fsScheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)).toUri();
                }
                return new FsMountPoint(fsScheme, new FsPath(this.file)).toUri();
            }
            if (null != this.enclArchive) {
                assert (null != this.enclEntryName);
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName).toUri();
            }
            return this.file.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    public FsPath toFsPath() {
        try {
            if (this == this.innerArchive) {
                FsScheme fsScheme = this.getScheme();
                if (null != this.enclArchive) {
                    assert (null != this.enclEntryName);
                    return new FsPath(new FsMountPoint(fsScheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)), FsEntryName.ROOT);
                }
                return new FsPath(new FsMountPoint(fsScheme, new FsPath(this.file)), FsEntryName.ROOT);
            }
            if (null != this.enclArchive) {
                assert (null != this.enclEntryName);
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName);
            }
            return new FsPath(this.file);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    @Nullable
    private FsScheme getScheme() {
        if (this != this.innerArchive) {
            return null;
        }
        FsController<?> fsController = this.controller;
        if (null != fsController) {
            return ((FsModel)fsController.getModel()).getMountPoint().getScheme();
        }
        return this.detector.getScheme(this.file.getPath());
    }

    @Override
    @Deprecated
    public Path toPath() {
        throw new UnsupportedOperationException("Use a Path constructor or method instead!");
    }

    @Override
    public boolean exists() {
        if (null != this.innerArchive) {
            try {
                FsEntry fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != fsEntry;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        if (null != this.innerArchive) {
            try {
                FsEntry fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != fsEntry && fsEntry.isType(Entry.Type.FILE);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        if (null != this.innerArchive) {
            try {
                FsEntry fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != fsEntry && fsEntry.isType(Entry.Type.DIRECTORY);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.isDirectory();
    }

    @Deprecated
    @CheckForNull
    public Icon getOpenIcon() {
        return this.isArchive() ? ((FsArchiveDriver)this.getDriver(this.getScheme())).getOpenIcon((FsModel)this.getController().getModel()) : null;
    }

    @Deprecated
    @CheckForNull
    public Icon getClosedIcon() {
        return this.isArchive() ? ((FsArchiveDriver)this.getDriver(this.getScheme())).getClosedIcon((FsModel)this.getController().getModel()) : null;
    }

    @Nullable
    private FsDriver getDriver(FsScheme fsScheme) {
        return this.detector.get().get(fsScheme);
    }

    @Override
    public boolean canRead() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isReadable(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isWritable(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isExecutable(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.canExecute();
    }

    @Override
    public boolean setReadOnly() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setReadOnly(this.getInnerFsEntryName());
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.setReadOnly();
    }

    @Override
    public long length() {
        if (null != this.innerArchive) {
            FsEntry fsEntry;
            try {
                fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return 0L;
            }
            if (null == fsEntry) {
                return 0L;
            }
            long l2 = fsEntry.getSize(Entry.Size.DATA);
            return -1L != l2 ? l2 : 0L;
        }
        return this.file.length();
    }

    @Override
    public long lastModified() {
        if (null != this.innerArchive) {
            FsEntry fsEntry;
            try {
                fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return 0L;
            }
            if (null == fsEntry) {
                return 0L;
            }
            long l2 = fsEntry.getTime(Entry.Access.WRITE);
            return -1L != l2 ? l2 : 0L;
        }
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long l2) {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setTime(this.getInnerFsEntryName(), BitField.of(Entry.Access.WRITE), l2, TConfig.get().getOutputPreferences());
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.setLastModified(l2);
    }

    @Override
    @Nullable
    public String[] list() {
        if (null != this.innerArchive) {
            FsEntry fsEntry;
            try {
                fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return null;
            }
            if (null == fsEntry) {
                return null;
            }
            Set<String> set = fsEntry.getMembers();
            return null == set ? null : set.toArray(new String[set.size()]);
        }
        return this.file.list();
    }

    @Override
    @Nullable
    public String[] list(@CheckForNull FilenameFilter filenameFilter) {
        if (null != this.innerArchive) {
            FsEntry fsEntry;
            try {
                fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return null;
            }
            Set<String> set = TFile.members(fsEntry);
            if (null == set) {
                return null;
            }
            if (null == filenameFilter) {
                return set.toArray(new String[set.size()]);
            }
            ArrayList<String> arrayList = new ArrayList<String>(set.size());
            for (String string : set) {
                if (!filenameFilter.accept(this, string)) continue;
                arrayList.add(string);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.file.list(filenameFilter);
    }

    @Nullable
    public TFile[] listFiles() {
        return this.listFiles((FilenameFilter)null, this.detector);
    }

    @Nullable
    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile[] listFiles(TArchiveDetector tArchiveDetector) {
        return this.listFiles((FilenameFilter)null, tArchiveDetector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filenameFilter) {
        return this.listFiles(filenameFilter, this.detector);
    }

    @Nullable
    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile[] listFiles(@CheckForNull FilenameFilter filenameFilter, TArchiveDetector tArchiveDetector) {
        if (null != this.innerArchive) {
            FsEntry fsEntry;
            try {
                fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return null;
            }
            return this.filter(TFile.members(fsEntry), filenameFilter, tArchiveDetector);
        }
        return this.filter(TFile.list(this.file.list(filenameFilter)), (FilenameFilter)null, tArchiveDetector);
    }

    @CheckForNull
    private static Set<String> members(@CheckForNull FsEntry fsEntry) {
        return null == fsEntry ? null : fsEntry.getMembers();
    }

    @CheckForNull
    private static List<String> list(@CheckForNull String[] stringArray) {
        return null == stringArray ? null : Arrays.asList(stringArray);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> collection, @CheckForNull FilenameFilter filenameFilter, TArchiveDetector tArchiveDetector) {
        if (null == collection) {
            return null;
        }
        if (null != filenameFilter) {
            ArrayList<TFile> arrayList = new ArrayList<TFile>(collection.size());
            for (String string : collection) {
                if (!filenameFilter.accept(this, string)) continue;
                arrayList.add(new TFile((File)this, string, tArchiveDetector));
            }
            return arrayList.toArray(new TFile[arrayList.size()]);
        }
        TFile[] tFileArray = new TFile[collection.size()];
        int n2 = 0;
        for (String string : collection) {
            tFileArray[n2++] = new TFile((File)this, string, tArchiveDetector);
        }
        return tFileArray;
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter fileFilter) {
        return this.listFiles(fileFilter, this.detector);
    }

    @Nullable
    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile[] listFiles(@CheckForNull FileFilter fileFilter, TArchiveDetector tArchiveDetector) {
        if (null != this.innerArchive) {
            FsEntry fsEntry;
            try {
                fsEntry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException iOException) {
                return null;
            }
            return this.filter(TFile.members(fsEntry), fileFilter, tArchiveDetector);
        }
        return this.filter(TFile.list(this.file.list()), fileFilter, tArchiveDetector);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> collection, @CheckForNull FileFilter fileFilter, TArchiveDetector tArchiveDetector) {
        if (null == collection) {
            return null;
        }
        if (null != fileFilter) {
            ArrayList<TFile> arrayList = new ArrayList<TFile>(collection.size());
            for (String string : collection) {
                TFile tFile = new TFile((File)this, string, tArchiveDetector);
                if (!fileFilter.accept(tFile)) continue;
                arrayList.add(tFile);
            }
            return arrayList.toArray(new TFile[arrayList.size()]);
        }
        TFile[] tFileArray = new TFile[collection.size()];
        int n2 = 0;
        for (String string : collection) {
            tFileArray[n2++] = new TFile((File)this, string, tArchiveDetector);
        }
        return tFileArray;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (null != this.innerArchive) {
            FsEntryName fsEntryName;
            FsController<?> fsController = this.innerArchive.getController();
            if (null != fsController.getEntry(fsEntryName = this.getInnerFsEntryName())) {
                return false;
            }
            fsController.mknod(fsEntryName, Entry.Type.FILE, TConfig.get().getOutputPreferences().set(FsOutputOption.EXCLUSIVE), null);
            return true;
        }
        return this.file.createNewFile();
    }

    @Override
    public boolean mkdirs() {
        if (null == this.innerArchive) {
            return this.file.mkdirs();
        }
        TFile tFile = this.getParentFile();
        if (null != tFile && !tFile.exists()) {
            tFile.mkdirs();
        }
        return this.mkdir();
    }

    @Override
    public boolean mkdir() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().mknod(this.getInnerFsEntryName(), Entry.Type.DIRECTORY, TConfig.get().getOutputPreferences(), null);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.file.mkdir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TFile mkdir(boolean bl2) throws IOException {
        TFile tFile = this.innerArchive;
        if (null != tFile) {
            Object object;
            if (bl2 && null != (object = this.getParentFile()) && !((TFile)object).exists()) {
                ((TFile)object).mkdir(bl2);
            }
            object = tFile.getController();
            FsEntryName fsEntryName = this.getInnerFsEntryName();
            try {
                ((FsController)object).mknod(fsEntryName, Entry.Type.DIRECTORY, TConfig.get().getOutputPreferences(), null);
                return this;
            }
            catch (IOException iOException) {
                FsEntry fsEntry = ((FsController)object).getEntry(fsEntryName);
                if (null != fsEntry && fsEntry.isType(Entry.Type.DIRECTORY)) return this;
                throw iOException;
            }
        } else {
            File file = this.file;
            if ((!bl2 ? file.mkdir() : file.mkdirs()) || file.isDirectory()) return this;
            throw new IOException(file + " (cannot create directory)");
        }
    }

    @Override
    @Deprecated
    public boolean delete() {
        try {
            TFile.rm(this);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public TFile rm() throws IOException {
        TFile.rm(this);
        return this;
    }

    public static void rm(File file) throws IOException {
        if (file instanceof TFile) {
            TFile tFile = (TFile)file;
            if (null != tFile.innerArchive) {
                tFile.innerArchive.getController().unlink(tFile.getInnerFsEntryName(), TConfig.get().getOutputPreferences());
                return;
            }
            file = tFile.file;
        }
        if (!file.delete()) {
            throw new IOException(file + " (cannot delete)");
        }
    }

    public TFile rm_r() throws IOException {
        TBIO.rm_r(this, this.detector);
        return this;
    }

    public static void rm_r(File file) throws IOException {
        TBIO.rm_r(file, file instanceof TFile ? ((TFile)file).detector : TArchiveDetector.NULL);
    }

    @Override
    public void deleteOnExit() {
        if (this.innerArchive != null) {
            throw new UnsupportedOperationException();
        }
        this.file.deleteOnExit();
    }

    @Override
    @Deprecated
    public boolean renameTo(File file) {
        try {
            TFile.mv(this, file, this.detector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public TFile mv(File file) throws IOException {
        TFile.mv(this, file, this.detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void mv(File file, File file2, TArchiveDetector tArchiveDetector) throws IOException {
        File file3;
        boolean bl2;
        File file4;
        boolean bl3;
        if (file instanceof TFile) {
            TFile tFile = (TFile)file;
            bl3 = null != tFile.getInnerArchive();
            file4 = tFile.getFile();
        } else {
            bl3 = false;
            file4 = file;
        }
        if (file2 instanceof TFile) {
            TFile tFile = (TFile)file2;
            bl2 = null != tFile.getInnerArchive();
            file3 = tFile.getFile();
        } else {
            bl2 = false;
            file3 = file2;
        }
        if (!bl3 && !bl2) {
            if (file4.renameTo(file3)) {
                return;
            }
            throw new IOException(file + " (cannot rename to " + file2 + ")");
        }
        TBIO.mv(file, file2, tArchiveDetector);
    }

    public static void cp(@WillClose InputStream inputStream, @WillClose OutputStream outputStream) throws IOException {
        Streams.copy(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public static void cp(@WillClose InputStream inputStream, File file) throws IOException {
        if (null == inputStream) {
            throw new NullPointerException();
        }
        TFileOutputStream tFileOutputStream = null;
        try {
            tFileOutputStream = new TFileOutputStream(file);
        }
        finally {
            if (null == tFileOutputStream) {
                inputStream.close();
            }
        }
        try {
            TFile.cp(inputStream, (OutputStream)tFileOutputStream);
        }
        catch (IOException iOException) {
            TFile.rm(file);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(File file, @WillClose OutputStream outputStream) throws IOException {
        if (null == outputStream) {
            throw new NullPointerException();
        }
        TFileInputStream tFileInputStream = null;
        try {
            tFileInputStream = new TFileInputStream(file);
        }
        finally {
            if (null == tFileInputStream) {
                outputStream.close();
            }
        }
        TFile.cp((InputStream)tFileInputStream, outputStream);
    }

    public TFile cp(File file) throws IOException {
        TBIO.cp(false, this, file);
        return this;
    }

    public static void cp(File file, File file2) throws IOException {
        TBIO.cp(false, file, file2);
    }

    public TFile cp_p(File file) throws IOException {
        TBIO.cp(true, this, file);
        return this;
    }

    public static void cp_p(File file, File file2) throws IOException {
        TBIO.cp(true, file, file2);
    }

    public TFile cp_r(File file) throws IOException {
        TBIO.cp_r(false, this, file, this.detector, this.detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_r(File file, File file2, TArchiveDetector tArchiveDetector) throws IOException {
        TBIO.cp_r(false, file, file2, tArchiveDetector, tArchiveDetector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_r(File file, File file2, TArchiveDetector tArchiveDetector, TArchiveDetector tArchiveDetector2) throws IOException {
        TBIO.cp_r(false, file, file2, tArchiveDetector, tArchiveDetector2);
    }

    public TFile cp_rp(File file) throws IOException {
        TBIO.cp_r(true, this, file, this.detector, this.detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_rp(File file, File file2, TArchiveDetector tArchiveDetector) throws IOException {
        TBIO.cp_r(true, file, file2, tArchiveDetector, tArchiveDetector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_rp(File file, File file2, TArchiveDetector tArchiveDetector, TArchiveDetector tArchiveDetector2) throws IOException {
        TBIO.cp_r(true, file, file2, tArchiveDetector, tArchiveDetector2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void input(@WillNotClose InputStream inputStream) throws IOException {
        if (null == inputStream) {
            throw new NullPointerException();
        }
        try {
            TFileOutputStream tFileOutputStream = new TFileOutputStream(this);
            try {
                Streams.cat(inputStream, tFileOutputStream);
            }
            finally {
                tFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            TFile.rm(this);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(@WillNotClose OutputStream outputStream) throws IOException {
        if (null == outputStream) {
            throw new NullPointerException();
        }
        TFileInputStream tFileInputStream = new TFileInputStream(this);
        try {
            Streams.cat(tFileInputStream, outputStream);
        }
        finally {
            tFileInputStream.close();
        }
    }

    public static void cat(@WillNotClose InputStream inputStream, @WillNotClose OutputStream outputStream) throws IOException {
        Streams.cat(inputStream, outputStream);
    }

    public TFile compact() throws IOException {
        if (this.isTopLevelArchive()) {
            TFile.compact(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compact(TFile tFile) throws IOException {
        assert (tFile.isArchive());
        tFile = tFile.getNormalizedFile();
        assert (tFile.isArchive());
        File file = TFile.getParent(tFile);
        String string = TFile.getSuffix(tFile);
        TConfig tConfig = TConfig.push();
        try {
            tConfig.setOutputPreferences(tConfig.getOutputPreferences().clear(FsOutputOption.GROW));
            TFile tFile2 = new TFile(TFile.createTempFile("tzp", string, file));
            tFile2.rm();
            try {
                tFile.cp_rp(tFile2);
                TVFS.umount(tFile);
                TVFS.umount(tFile2);
                if (!TFile.move(tFile2.toNonArchiveFile(), tFile.toNonArchiveFile())) {
                    throw new IOException(tFile2 + " (cannot move to " + tFile + ")");
                }
            }
            catch (IOException iOException) {
                block11: {
                    try {
                        tFile2.rm();
                    }
                    catch (IOException iOException2) {
                        if (!JSE7.AVAILABLE) break block11;
                        iOException.addSuppressed(iOException2);
                    }
                }
                throw iOException;
            }
        }
        finally {
            tConfig.close();
        }
    }

    private static File getParent(File file) {
        File file2 = file.getParentFile();
        return null != file2 ? file2 : CURRENT_DIRECTORY;
    }

    @Nullable
    private static String getSuffix(TFile tFile) {
        FsScheme fsScheme = tFile.getScheme();
        return null != fsScheme ? "." + fsScheme : null;
    }

    private static boolean move(File file, File file2) {
        return file.exists() && (!file2.exists() || file2.delete()) && file.renameTo(file2);
    }
}

