/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import java.net.URI;
import java.net.URISyntaxException;
import zz.de.schlichtherle.truezip.file.ExpertFeature;
import zz.de.schlichtherle.truezip.file.TConfig;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.fs.FsFilteringManager;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncOptions;
import zz.de.schlichtherle.truezip.fs.FsUriModifier;
import zz.de.schlichtherle.truezip.util.BitField;

public final class TVFS {
    private TVFS() {
    }

    public static void umount() throws FsSyncException {
        TVFS.sync(FsSyncOptions.UMOUNT);
    }

    public static void umount(TFile tFile) throws FsSyncException {
        TVFS.sync(tFile, FsSyncOptions.UMOUNT);
    }

    public static void umount(FsMountPoint fsMountPoint) throws FsSyncException {
        TVFS.sync(fsMountPoint, FsSyncOptions.UMOUNT);
    }

    static FsMountPoint mountPoint(TFile tFile) {
        if (tFile.isArchive()) {
            return ((FsModel)tFile.getController().getModel()).getMountPoint();
        }
        try {
            return new FsMountPoint(new URI(tFile.getFile().toURI() + "/"), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsSyncOption ... fsSyncOptionArray) throws FsSyncException {
        TVFS.sync(FsSyncOptions.of(fsSyncOptionArray));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        TConfig.get().getFsManager().sync(bitField);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tFile, FsSyncOption ... fsSyncOptionArray) throws FsSyncException {
        TVFS.sync(tFile, FsSyncOptions.of(fsSyncOptionArray));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tFile, BitField<FsSyncOption> bitField) throws FsSyncException {
        TVFS.sync(TVFS.mountPoint(tFile), bitField);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint fsMountPoint, FsSyncOption ... fsSyncOptionArray) throws FsSyncException {
        TVFS.sync(fsMountPoint, FsSyncOptions.of(fsSyncOptionArray));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint fsMountPoint, BitField<FsSyncOption> bitField) throws FsSyncException {
        new FsFilteringManager(TConfig.get().getFsManager(), fsMountPoint).sync(bitField);
    }
}

