/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file.swing;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.swing.TFileSystemView;
import zz.de.schlichtherle.truezip.file.swing.TFileView;

public final class TFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 936528972682036204L;

    public TFileChooser() {
        this(null, null);
    }

    public TFileChooser(@CheckForNull TFile tFile) {
        this(tFile, null);
    }

    public TFileChooser(@CheckForNull TFileSystemView tFileSystemView) {
        this(null, tFileSystemView);
    }

    public TFileChooser(@CheckForNull TFile tFile, @CheckForNull TFileSystemView tFileSystemView) {
        super(tFile, (FileSystemView)(null != tFileSystemView ? tFileSystemView : new TFileSystemView()));
        super.setFileView(new TFileView(super.getFileView()));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        super.setFileSystemView(new TFileSystemView());
    }

    @Override
    public TFile getCurrentDirectory() {
        return this.getFileSystemView().wrap(super.getCurrentDirectory());
    }

    @Override
    public TFileSystemView getFileSystemView() {
        return (TFileSystemView)super.getFileSystemView();
    }

    @Override
    public void setFileSystemView(FileSystemView fileSystemView) {
        if (null == fileSystemView) {
            throw new NullPointerException();
        }
        super.setFileSystemView((TFileSystemView)fileSystemView);
    }

    @Override
    @Nullable
    public TFile getSelectedFile() {
        return this.getFileSystemView().wrap(super.getSelectedFile());
    }

    @Nullable
    public TFile[] getSelectedFiles() {
        File[] fileArray = super.getSelectedFiles();
        if (null == fileArray) {
            return null;
        }
        TFileSystemView tFileSystemView = this.getFileSystemView();
        TFile[] tFileArray = new TFile[fileArray.length];
        int n2 = fileArray.length;
        while (0 <= --n2) {
            tFileArray[n2] = tFileSystemView.wrap(fileArray[n2]);
        }
        return tFileArray;
    }
}

