/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file.swing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileComparator;
import zz.de.schlichtherle.truezip.file.swing.TFileTreeCellRenderer;
import zz.de.schlichtherle.truezip.file.swing.TFileTreeModel;

public final class TFileTree
extends JTree {
    private static final long serialVersionUID = 1064787562479927601L;
    private static final String PROPERTY_DISPLAYING_SUFFIXES = "displayingSuffixes";
    private static final String PROPERTY_EDITING_SUFFIXES = "editingSuffixes";
    private static final String PROPERTY_DEFAULT_SUFFIX = "defaultSuffix";
    private final Controller controller = new Controller();
    private boolean displayingSuffixes = true;
    private boolean editingSuffixes = true;
    @CheckForNull
    private String defaultSuffix;
    @CheckForNull
    private transient TFile editedNode;

    public TFileTree() {
        this(new TFileTreeModel(null, null, new TFileComparator()));
    }

    public TFileTree(TFile tFile) {
        this(new TFileTreeModel(tFile, null, new TFileComparator()));
    }

    public TFileTree(TFileTreeModel tFileTreeModel) {
        super(tFileTreeModel);
        super.addTreeExpansionListener(this.controller);
        super.setCellRenderer(new TFileTreeCellRenderer(this));
    }

    @Override
    public TFileTreeModel getModel() {
        return (TFileTreeModel)super.getModel();
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setModel(TreeModel treeModel) {
        if (null == treeModel) {
            throw new NullPointerException();
        }
        super.setModel((TFileTreeModel)treeModel);
    }

    @Override
    public void setEditable(boolean bl2) {
        if (bl2) {
            super.setEditable(true);
            this.getCellEditor().addCellEditorListener(this.controller);
        } else {
            TreeCellEditor treeCellEditor = this.getCellEditor();
            if (treeCellEditor != null) {
                treeCellEditor.removeCellEditorListener(this.controller);
            }
            super.setEditable(false);
        }
    }

    public boolean isDisplayingSuffixes() {
        return this.displayingSuffixes;
    }

    public void setDisplayingSuffixes(boolean bl2) {
        boolean bl3 = this.displayingSuffixes;
        this.displayingSuffixes = bl2;
        this.firePropertyChange(PROPERTY_DISPLAYING_SUFFIXES, bl3, bl2);
    }

    public boolean isEditingSuffixes() {
        return this.editingSuffixes;
    }

    public void setEditingSuffixes(boolean bl2) {
        boolean bl3 = this.editingSuffixes;
        this.editingSuffixes = bl2;
        this.firePropertyChange(PROPERTY_EDITING_SUFFIXES, bl3, bl2);
    }

    @Nullable
    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(@CheckForNull String string) {
        String string2 = this.defaultSuffix;
        if (null != string) {
            if ((string = string.trim()).length() <= 0) {
                string = null;
            } else if (string.charAt(0) != '.') {
                string = "." + string;
            }
        }
        this.defaultSuffix = string;
        this.firePropertyChange(PROPERTY_DEFAULT_SUFFIX, string2, string);
    }

    @Nullable
    TFile getEditedNode() {
        return this.editedNode;
    }

    @Override
    public boolean isEditing() {
        return null != this.editedNode;
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
        this.editedNode = (TFile)treePath.getLastPathComponent();
        super.startEditingAtPath(treePath);
    }

    @Override
    public void cancelEditing() {
        this.editedNode = null;
        super.cancelEditing();
    }

    @Override
    public boolean stopEditing() {
        boolean bl2 = super.stopEditing();
        if (bl2) {
            this.editedNode = null;
        }
        return bl2;
    }

    protected void onEditingStopped(ChangeEvent changeEvent) {
        Object object;
        TreeCellEditor treeCellEditor = (TreeCellEditor)changeEvent.getSource();
        String string = treeCellEditor.getCellEditorValue().toString().trim();
        TFile tFile = (TFile)this.getLeadSelectionPath().getLastPathComponent();
        TFile tFile2 = tFile.getParentFile();
        assert (tFile2 != null);
        if (!tFile.isDirectory()) {
            if (this.isDisplayingSuffixes() && this.isEditingSuffixes()) {
                String string2;
                object = this.getSuffix(string);
                if (null == object && (string2 = this.getDefaultSuffix()) != null) {
                    string = string + string2;
                }
            } else {
                object = this.getSuffix(tFile.getName());
                if (null != object) {
                    string = string + (String)object;
                }
            }
        }
        object = new TFile((File)tFile2, string);
        try {
            this.mv(tFile, (TFile)object);
        }
        catch (IOException iOException) {
            Logger.getLogger(TFileTree.class.getName()).log(Level.WARNING, iOException.toString(), iOException);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Nullable
    private String getSuffix(String string) {
        int n2 = string.lastIndexOf(46);
        return n2 != -1 ? string.substring(n2) : null;
    }

    @Override
    public String convertValueToText(Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        TFile tFile = (TFile)object;
        TFile tFile2 = this.getEditedNode();
        if (tFile != tFile2 && !tFile.exists()) {
            return "?";
        }
        String string = tFile.getName();
        if (string.length() <= 0) {
            return tFile.getPath();
        }
        if (tFile.isDirectory() || this.isDisplayingSuffixes() && (!tFile.equals(tFile2) || this.isEditingSuffixes())) {
            return string;
        }
        int n3 = string.lastIndexOf(46);
        return n3 != -1 ? string.substring(0, n3) : string;
    }

    public void refresh() {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFileTreeModel.getRoot());
        if (null != treePath) {
            this.refresh(new TreePath[]{treePath});
        }
    }

    public void refresh(TFile tFile) {
        if (tFile == null) {
            throw new NullPointerException();
        }
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (treePath != null) {
            this.refresh(new TreePath[]{treePath});
        }
    }

    public void refresh(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = this.getLeadSelectionPath();
        TreePath treePath2 = this.getAnchorSelectionPath();
        TreePath[] treePathArray2 = this.getSelectionPaths();
        for (TreePath treePath3 : treePathArray) {
            Enumeration<TreePath> enumeration = this.getExpandedDescendants(treePath3);
            tFileTreeModel.refresh((TFile)treePath3.getLastPathComponent());
            this.setExpandedDescendants(enumeration);
        }
        this.setSelectionPaths(treePathArray2);
        this.setAnchorSelectionPath(treePath2);
        this.setLeadSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void setExpandedDescendants(Enumeration<TreePath> enumeration) {
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.setExpandedState(enumeration.nextElement(), true);
        }
    }

    public boolean createNewFile(TFile tFile) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (null == treePath) {
            return false;
        }
        if (!tFileTreeModel.createNewFile(tFile)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public void mkdir(TFile tFile, boolean bl2) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (null == treePath) {
            return;
        }
        tFileTreeModel.mkdir(tFile, bl2);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public void cp(@WillClose InputStream inputStream, TFile tFile) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        tFileTreeModel.cp(inputStream, tFile);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public void cp(TFile tFile, TFile tFile2) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile2);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        tFileTreeModel.cp(tFile, tFile2);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public void cp_r(TFile tFile, TFile tFile2) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile2);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        tFileTreeModel.cp_r(tFile, tFile2);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public void cp_p(TFile tFile, TFile tFile2) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile2);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        tFileTreeModel.cp_p(tFile, tFile2);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public void cp_rp(TFile tFile, TFile tFile2) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile2);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        tFileTreeModel.cp_rp(tFile, tFile2);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public void mv(TFile tFile, TFile tFile2) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile2);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        TreePath treePath2 = tFileTreeModel.newTreePath(tFile);
        Enumeration<TreePath> enumeration = treePath2 == null ? null : this.getExpandedDescendants(treePath2);
        tFileTreeModel.mv(tFile, tFile2);
        if (null != enumeration) {
            while (enumeration.hasMoreElements()) {
                this.setExpandedState(this.substPath(enumeration.nextElement(), treePath2, treePath), true);
            }
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private TreePath substPath(TreePath treePath, TreePath treePath2, TreePath treePath3) {
        TFile tFile = (TFile)treePath.getLastPathComponent();
        if (tFile.equals(treePath2.getLastPathComponent())) {
            return treePath3;
        }
        TreePath treePath4 = this.substPath(treePath.getParentPath(), treePath2, treePath3);
        return treePath4.pathByAddingChild(new TFile((File)((TFile)treePath4.getLastPathComponent()), tFile.getName()));
    }

    public void rm(TFile tFile) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        this.scrollPathToVisible(treePath);
        int n2 = this.getRowForPath(treePath);
        tFileTreeModel.rm(tFile);
        this.setSelectionRow(n2);
    }

    public void rm_r(TFile tFile) throws IOException {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (null == treePath) {
            throw new IllegalArgumentException("node");
        }
        this.scrollPathToVisible(treePath);
        int n2 = this.getRowForPath(treePath);
        tFileTreeModel.rm_r(tFile);
        this.setSelectionRow(n2);
    }

    public void setSelectionNode(TFile tFile) {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (null != treePath) {
            this.setSelectionPath(treePath);
        }
    }

    public void setSelectionNodes(TFile[] tFileArray) {
        int n2;
        TFileTreeModel tFileTreeModel = this.getModel();
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        int n3 = tFileArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            TreePath treePath = tFileTreeModel.newTreePath(tFileArray[n2]);
            if (treePath == null) continue;
            linkedList.add(treePath);
        }
        n2 = linkedList.size();
        if (n2 > 0) {
            TreePath[] treePathArray = new TreePath[n2];
            linkedList.toArray(treePathArray);
            this.setSelectionPaths(treePathArray);
        }
    }

    public void scrollNodeToVisible(TFile tFile) {
        TFileTreeModel tFileTreeModel = this.getModel();
        TreePath treePath = tFileTreeModel.newTreePath(tFile);
        if (treePath != null) {
            this.scrollPathToVisible(treePath);
        }
    }

    private final class Controller
    implements Serializable,
    CellEditorListener,
    TreeExpansionListener {
        private static final long serialVersionUID = 6402557248752695675L;

        private Controller() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TFileTree.this.getModel().forget((TFile)treeExpansionEvent.getPath().getLastPathComponent());
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            TFileTree.this.onEditingStopped(changeEvent);
        }
    }
}

