/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.DecoratingEntry;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystem;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystemOperation;
import zz.de.schlichtherle.truezip.fs.FsCovariantEntry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import zz.de.schlichtherle.truezip.fs.FsFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsInputOptions;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsLockModelController;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsSyncException;
import zz.de.schlichtherle.truezip.fs.FsOperationContext;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.Streams;
import zz.de.schlichtherle.truezip.socket.DelegatingInputSocket;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;

@NotThreadSafe
abstract class FsBasicArchiveController<E extends FsArchiveEntry>
extends FsLockModelController {
    private static final Logger logger = Logger.getLogger(FsBasicArchiveController.class.getName(), FsBasicArchiveController.class.getName());
    private final ThreadLocal<FsOperationContext> context = new ThreadLocal();

    FsBasicArchiveController(FsLockModel fsLockModel) {
        super(fsLockModel);
        if (null == fsLockModel.getParent()) {
            throw new IllegalArgumentException();
        }
    }

    @Nullable
    final FsOperationContext getContext() {
        return this.context.get();
    }

    final void setContext(@CheckForNull FsOperationContext fsOperationContext) {
        if (null != fsOperationContext) {
            this.context.set(fsOperationContext);
        } else {
            this.context.remove();
        }
    }

    final FsArchiveFileSystem<E> autoMount() throws IOException {
        return this.autoMount(false);
    }

    abstract FsArchiveFileSystem<E> autoMount(boolean var1) throws IOException;

    @Override
    public final boolean isReadOnly() throws IOException {
        return this.autoMount().isReadOnly();
    }

    @Override
    public final FsEntry getEntry(FsEntryName fsEntryName) throws IOException {
        return this.autoMount().getEntry(fsEntryName);
    }

    @Override
    public final boolean isReadable(FsEntryName fsEntryName) throws IOException {
        return this.autoMount().getEntry(fsEntryName) != null;
    }

    @Override
    public final boolean isWritable(FsEntryName fsEntryName) throws IOException {
        return this.autoMount().isWritable(fsEntryName);
    }

    @Override
    public final void setReadOnly(FsEntryName fsEntryName) throws IOException {
        this.autoMount().setReadOnly(fsEntryName);
    }

    @Override
    public final boolean setTime(FsEntryName fsEntryName, Map<Entry.Access, Long> map, BitField<FsOutputOption> bitField) throws IOException {
        this.checkSync(fsEntryName, null);
        return this.autoMount().setTime(fsEntryName, map);
    }

    @Override
    public final boolean setTime(FsEntryName fsEntryName, BitField<Entry.Access> bitField, long l2, BitField<FsOutputOption> bitField2) throws IOException {
        this.checkSync(fsEntryName, null);
        return this.autoMount().setTime(fsEntryName, bitField, l2);
    }

    @Override
    public final InputSocket<?> getInputSocket(final FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        if (null == fsEntryName) {
            throw new NullPointerException();
        }
        final class Input
        extends DelegatingInputSocket<FsArchiveEntry> {
            Input() {
            }

            @Override
            public FsArchiveEntry getLocalTarget() throws IOException {
                FsBasicArchiveController.this.checkSync(fsEntryName, Entry.Access.READ);
                FsCovariantEntry fsCovariantEntry = FsBasicArchiveController.this.autoMount().getEntry(fsEntryName);
                if (null == fsCovariantEntry) {
                    throw new FsEntryNotFoundException((FsModel)FsBasicArchiveController.this.getModel(), fsEntryName, "no such entry");
                }
                Object e2 = fsCovariantEntry.get(Entry.Type.FILE);
                if (null == e2) {
                    throw new FsEntryNotFoundException((FsModel)FsBasicArchiveController.this.getModel(), fsEntryName, "expected FILE entry, but is a " + fsCovariantEntry.getTypes() + " entry");
                }
                return e2;
            }

            @Override
            protected InputSocket<? extends FsArchiveEntry> getDelegate() throws IOException {
                this.getPeerTarget();
                return FsBasicArchiveController.this.getInputSocket(this.getLocalTarget().getName());
            }
        }
        return new Input();
    }

    abstract InputSocket<? extends E> getInputSocket(String var1);

    @Override
    public final OutputSocket<?> getOutputSocket(final FsEntryName fsEntryName, final BitField<FsOutputOption> bitField, final Entry entry) {
        if (null == fsEntryName) {
            throw new NullPointerException();
        }
        if (null == bitField) {
            throw new NullPointerException();
        }
        final class Output
        extends OutputSocket<FsArchiveEntry> {
            Output() {
            }

            @Override
            public FsArchiveEntry getLocalTarget() throws IOException {
                Object e2 = ((FsCovariantEntry)this.mknod().getTarget()).getEntry();
                if (bitField.get(FsOutputOption.APPEND)) {
                    return new ProxyEntry((FsArchiveEntry)e2);
                }
                return e2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OutputStream newOutputStream() throws IOException {
                FsArchiveFileSystemOperation fsArchiveFileSystemOperation = this.mknod();
                Object e2 = ((FsCovariantEntry)fsArchiveFileSystemOperation.getTarget()).getEntry();
                InputStream inputStream = null;
                if (bitField.get(FsOutputOption.APPEND)) {
                    try {
                        inputStream = FsBasicArchiveController.this.getInputSocket(fsEntryName, FsInputOptions.NONE).newInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    OutputSocket outputSocket = FsBasicArchiveController.this.getOutputSocket(e2);
                    if (null == inputStream) {
                        outputSocket.bind(this);
                    }
                    OutputStream outputStream = outputSocket.newOutputStream();
                    try {
                        fsArchiveFileSystemOperation.commit();
                        if (inputStream != null) {
                            Streams.cat(inputStream, outputStream);
                        }
                    }
                    catch (IOException iOException) {
                        outputStream.close();
                        throw iOException;
                    }
                    OutputStream outputStream2 = outputStream;
                    return outputStream2;
                }
                finally {
                    if (null != inputStream) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            throw new InputException(iOException);
                        }
                    }
                }
            }

            FsArchiveFileSystemOperation<E> mknod() throws IOException {
                FsBasicArchiveController.this.checkSync(fsEntryName, Entry.Access.WRITE);
                return FsBasicArchiveController.this.autoMount(!fsEntryName.isRoot() && bitField.get(FsOutputOption.CREATE_PARENTS)).mknod(fsEntryName, Entry.Type.FILE, bitField, entry);
            }
        }
        return new Output();
    }

    abstract OutputSocket<? extends E> getOutputSocket(E var1);

    @Override
    public final void mknod(FsEntryName fsEntryName, Entry.Type type, BitField<FsOutputOption> bitField, Entry entry) throws IOException {
        if (fsEntryName.isRoot()) {
            try {
                this.autoMount();
            }
            catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
                if (Entry.Type.DIRECTORY != type) {
                    throw fsFalsePositiveArchiveException;
                }
                this.autoMount(true);
                return;
            }
            throw new FsEntryNotFoundException((FsModel)this.getModel(), fsEntryName, "directory entry exists already");
        }
        this.checkSync(fsEntryName, null);
        this.autoMount(bitField.get(FsOutputOption.CREATE_PARENTS)).mknod(fsEntryName, type, bitField, entry).commit();
    }

    @Override
    public void unlink(FsEntryName fsEntryName, BitField<FsOutputOption> bitField) throws IOException {
        int n2;
        this.checkSync(fsEntryName, null);
        FsArchiveFileSystem<E> fsArchiveFileSystem = this.autoMount();
        fsArchiveFileSystem.unlink(fsEntryName);
        if (fsEntryName.isRoot() && 0 != (n2 = fsArchiveFileSystem.getSize() - 1)) {
            logger.log(Level.WARNING, "unlink.absolute", new Object[]{this.getMountPoint(), n2});
        }
    }

    abstract void checkSync(FsEntryName var1, @CheckForNull Entry.Access var2) throws FsNeedsSyncException;

    private static final class ProxyEntry
    extends DecoratingEntry<FsArchiveEntry>
    implements FsArchiveEntry {
        ProxyEntry(FsArchiveEntry fsArchiveEntry) {
            super(fsArchiveEntry);
        }

        @Override
        public Entry.Type getType() {
            return ((FsArchiveEntry)this.delegate).getType();
        }

        @Override
        public boolean setSize(Entry.Size size, long l2) {
            return ((FsArchiveEntry)this.delegate).setSize(size, l2);
        }

        @Override
        public boolean setTime(Entry.Access access, long l2) {
            return ((FsArchiveEntry)this.delegate).setTime(access, l2);
        }
    }
}

