/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.IOException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncWarningException;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;

public abstract class FsController<M extends FsModel> {
    public abstract M getModel();

    @Nullable
    public abstract FsController<?> getParent();

    public abstract boolean isReadOnly() throws IOException;

    @Nullable
    public abstract FsEntry getEntry(FsEntryName var1) throws IOException;

    public abstract boolean isReadable(FsEntryName var1) throws IOException;

    public abstract boolean isWritable(FsEntryName var1) throws IOException;

    public boolean isExecutable(FsEntryName fsEntryName) throws IOException {
        return false;
    }

    public abstract void setReadOnly(FsEntryName var1) throws IOException;

    public boolean setTime(FsEntryName fsEntryName, Map<Entry.Access, Long> map, BitField<FsOutputOption> bitField) throws IOException {
        boolean bl2 = true;
        for (Map.Entry<Entry.Access, Long> entry : map.entrySet()) {
            long l2 = entry.getValue();
            bl2 &= 0L <= l2 && this.setTime(fsEntryName, BitField.of((Enum)entry.getKey()), l2, bitField);
        }
        return bl2;
    }

    public abstract boolean setTime(FsEntryName var1, BitField<Entry.Access> var2, long var3, BitField<FsOutputOption> var5) throws IOException;

    public abstract InputSocket<?> getInputSocket(FsEntryName var1, BitField<FsInputOption> var2);

    public abstract OutputSocket<?> getOutputSocket(FsEntryName var1, BitField<FsOutputOption> var2, @CheckForNull Entry var3);

    public abstract void mknod(FsEntryName var1, Entry.Type var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4) throws IOException;

    public abstract void unlink(FsEntryName var1, BitField<FsOutputOption> var2) throws IOException;

    public abstract void sync(BitField<FsSyncOption> var1) throws FsSyncWarningException, FsSyncException;

    public final boolean equals(@CheckForNull Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.format("%s[model=%s]", this.getClass().getName(), this.getModel());
    }
}

