/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.CharConversionException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsEntry;

@NotThreadSafe
public final class FsCovariantEntry<E extends FsArchiveEntry>
extends FsEntry
implements Cloneable {
    private final String name;
    private EnumMap<Entry.Type, E> map = new EnumMap(Entry.Type.class);
    @Nullable
    private Entry.Type key;
    @Nullable
    private LinkedHashSet<String> members;

    public FsCovariantEntry(String string) {
        this.name = string.toString();
    }

    public FsCovariantEntry<E> clone(FsArchiveDriver<E> fsArchiveDriver) {
        FsCovariantEntry fsCovariantEntry;
        try {
            fsCovariantEntry = (FsCovariantEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        fsCovariantEntry.map = new EnumMap<Entry.Type, E>(Entry.Type.class);
        EnumMap<Entry.Type, E> enumMap = fsCovariantEntry.map;
        try {
            for (Map.Entry<Entry.Type, E> entry : this.map.entrySet()) {
                FsArchiveEntry fsArchiveEntry = (FsArchiveEntry)entry.getValue();
                enumMap.put(entry.getKey(), fsArchiveDriver.newEntry(fsArchiveEntry.getName(), fsArchiveEntry.getType(), fsArchiveEntry));
            }
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionError((Object)charConversionException);
        }
        LinkedHashSet<String> linkedHashSet = this.members;
        if (null != linkedHashSet) {
            fsCovariantEntry.members = (LinkedHashSet)linkedHashSet.clone();
        }
        return fsCovariantEntry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.name.isEmpty();
    }

    @Nullable
    public Entry.Type getKey() {
        return this.key;
    }

    public void setKey(@Nullable Entry.Type type) {
        this.key = type;
    }

    @Nullable
    public E put(Entry.Type type, E e2) {
        this.key = type;
        return (E)((FsArchiveEntry)this.map.put(this.key, e2));
    }

    @Nullable
    public E remove(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.remove((Object)type));
    }

    @Nullable
    public E get(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.get((Object)type));
    }

    @Nullable
    public E getEntry() {
        return (E)((FsArchiveEntry)this.map.get((Object)this.key));
    }

    public Collection<E> getEntries() {
        return this.map.values();
    }

    @Override
    public Set<Entry.Type> getTypes() {
        return this.map.keySet();
    }

    @Override
    public boolean isType(Entry.Type type) {
        return this.map.containsKey((Object)type);
    }

    @Override
    public long getSize(Entry.Size size) {
        if (Entry.Type.DIRECTORY == this.key) {
            return -1L;
        }
        return ((FsArchiveEntry)this.map.get((Object)this.key)).getSize(size);
    }

    @Override
    public long getTime(Entry.Access access) {
        return ((FsArchiveEntry)this.map.get((Object)this.key)).getTime(access);
    }

    @Override
    @Nullable
    public Set<String> getMembers() {
        if (!this.isType(Entry.Type.DIRECTORY)) {
            this.members = null;
            return null;
        }
        LinkedHashSet<String> linkedHashSet = this.members;
        return null != linkedHashSet ? linkedHashSet : (this.members = new LinkedHashSet());
    }

    public boolean add(String string) {
        return this.getMembers().add(string);
    }

    public boolean remove(String string) {
        return this.getMembers().remove(string);
    }
}

