/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsCompositeDriver;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncWarningException;
import zz.de.schlichtherle.truezip.util.BitField;

@ThreadSafe
public abstract class FsManager
implements Iterable<FsController<?>> {
    public <E extends FsArchiveEntry> FsController<?> newController(FsArchiveDriver<E> fsArchiveDriver, FsModel fsModel, FsController<?> fsController) {
        throw new UnsupportedOperationException();
    }

    public abstract FsController<?> getController(FsMountPoint var1, FsCompositeDriver var2);

    public abstract int getSize();

    @Override
    public abstract Iterator<FsController<?>> iterator();

    public void sync(BitField<FsSyncOption> bitField) throws FsSyncWarningException, FsSyncException {
        if (bitField.get(FsSyncOption.ABORT_CHANGES)) {
            throw new IllegalArgumentException();
        }
        FsSyncExceptionBuilder fsSyncExceptionBuilder = new FsSyncExceptionBuilder();
        for (FsController<?> fsController : this) {
            try {
                fsController.sync(bitField);
            }
            catch (FsSyncException fsSyncException) {
                fsSyncExceptionBuilder.warn(fsSyncException);
            }
        }
        fsSyncExceptionBuilder.check();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getName(), this.getSize());
    }
}

