/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsPath;
import zz.de.schlichtherle.truezip.fs.FsScheme;
import zz.de.schlichtherle.truezip.fs.FsUriModifier;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import zz.de.schlichtherle.truezip.util.UriBuilder;

@Immutable
@SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public final class FsMountPoint
implements Serializable,
Comparable<FsMountPoint> {
    private static final long serialVersionUID = 5723957985634276648L;
    public static final String SEPARATOR = "!/";
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;
    @Nullable
    private transient FsPath path;
    @Nullable
    private volatile transient FsScheme scheme;
    @Nullable
    private volatile transient URI hierarchical;

    @Deprecated
    public static FsMountPoint create(String string) {
        return FsMountPoint.create(string, FsUriModifier.NULL);
    }

    @Deprecated
    public static FsMountPoint create(String string, FsUriModifier fsUriModifier) {
        try {
            return new FsMountPoint(string, fsUriModifier);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static FsMountPoint create(URI uRI) {
        return FsMountPoint.create(uRI, FsUriModifier.NULL);
    }

    public static FsMountPoint create(URI uRI, FsUriModifier fsUriModifier) {
        try {
            return new FsMountPoint(uRI, fsUriModifier);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static FsMountPoint create(FsScheme fsScheme, FsPath fsPath) {
        try {
            return new FsMountPoint(fsScheme, fsPath);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Deprecated
    public FsMountPoint(String string) throws URISyntaxException {
        this.parse(new URI(string), FsUriModifier.NULL);
    }

    @Deprecated
    public FsMountPoint(String string, FsUriModifier fsUriModifier) throws URISyntaxException {
        this.parse(new URI(string), fsUriModifier);
    }

    public FsMountPoint(URI uRI) throws URISyntaxException {
        this.parse(uRI, FsUriModifier.NULL);
    }

    public FsMountPoint(URI uRI, FsUriModifier fsUriModifier) throws URISyntaxException {
        this.parse(uRI, fsUriModifier);
    }

    public FsMountPoint(FsScheme fsScheme, FsPath fsPath) throws URISyntaxException {
        URI uRI = fsPath.toUri();
        if (!uRI.isAbsolute()) {
            throw new QuotedUriSyntaxException(uRI, "Path not absolute");
        }
        String string = fsPath.getEntryName().toUri().getPath();
        if (0 == string.length()) {
            throw new QuotedUriSyntaxException(uRI, "Empty entry name");
        }
        this.uri = new UriBuilder(true).scheme(fsScheme.toString()).path(uRI.getScheme() + ':' + uRI.getRawSchemeSpecificPart() + SEPARATOR).toUri();
        this.scheme = fsScheme;
        this.path = fsPath;
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(objectInputStream.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (InvalidObjectException)new InvalidObjectException(uRISyntaxException.toString()).initCause(uRISyntaxException);
        }
    }

    private void parse(URI uRI, FsUriModifier fsUriModifier) throws URISyntaxException {
        if (null != (uRI = fsUriModifier.modify(uRI, FsUriModifier.PostFix.MOUNT_POINT)).getRawQuery()) {
            throw new QuotedUriSyntaxException(uRI, "Query not allowed");
        }
        if (null != uRI.getRawFragment()) {
            throw new QuotedUriSyntaxException(uRI, "Fragment not allowed");
        }
        if (uRI.isOpaque()) {
            URI uRI2;
            String string = uRI.getRawSchemeSpecificPart();
            int n2 = string.lastIndexOf(SEPARATOR);
            if (string.length() - 2 != n2) {
                throw new QuotedUriSyntaxException(uRI, "Doesn't end with mount point separator \"!/\"");
            }
            this.path = new FsPath(new URI(string.substring(0, n2)), fsUriModifier);
            URI uRI3 = this.path.toUri();
            if (!uRI3.isAbsolute()) {
                throw new QuotedUriSyntaxException(uRI, "Path not absolute");
            }
            if (0 == this.path.getEntryName().getPath().length()) {
                throw new QuotedUriSyntaxException(uRI, "Empty URI path of entry name of path");
            }
            if (FsUriModifier.NULL != fsUriModifier && !uRI.equals(uRI2 = new UriBuilder(true).scheme(uRI.getScheme()).path(uRI3.getScheme() + ':' + uRI3.getRawSchemeSpecificPart() + SEPARATOR).toUri())) {
                uRI = uRI2;
            }
        } else {
            if (!uRI.isAbsolute()) {
                throw new QuotedUriSyntaxException(uRI, "Not absolute");
            }
            if (!uRI.getRawPath().endsWith("/")) {
                throw new QuotedUriSyntaxException(uRI, "URI path doesn't end with separator \"/\"");
            }
            this.path = null;
        }
        this.uri = uRI;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (this.toUri().isAbsolute());
        assert (null == this.toUri().getRawQuery());
        assert (null == this.toUri().getRawFragment());
        if (this.toUri().isOpaque()) {
            assert (this.toUri().getRawSchemeSpecificPart().endsWith(SEPARATOR));
            assert (null != this.getPath());
            assert (this.getPath().toUri().isAbsolute());
            assert (null == this.getPath().toUri().getRawFragment());
            assert (0 != this.getPath().getEntryName().toUri().getRawPath().length());
        } else {
            assert (this.toUri().normalize() == this.toUri());
            assert (this.toUri().getRawPath().endsWith("/"));
            assert (null == this.getPath());
        }
        return true;
    }

    public URI toUri() {
        return this.uri;
    }

    @Deprecated
    public URI getUri() {
        return this.uri;
    }

    public URI toHierarchicalUri() {
        URI uRI = this.hierarchical;
        return null != uRI ? uRI : (this.hierarchical = this.uri.isOpaque() ? this.path.toHierarchicalUri() : this.uri);
    }

    @Deprecated
    public URI getHierarchicalUri() {
        return this.toHierarchicalUri();
    }

    public FsScheme getScheme() {
        FsScheme fsScheme = this.scheme;
        return null != fsScheme ? fsScheme : (this.scheme = FsScheme.create(this.uri.getScheme()));
    }

    @Nullable
    public FsPath getPath() {
        return this.path;
    }

    @Nullable
    public FsMountPoint getParent() {
        assert (null == this.path || null != this.path.getMountPoint());
        return null == this.path ? null : this.path.getMountPoint();
    }

    public FsPath resolve(FsEntryName fsEntryName) {
        return new FsPath(this, fsEntryName);
    }

    public boolean equals(@CheckForNull Object object) {
        return this == object || object instanceof FsMountPoint && this.uri.equals(((FsMountPoint)object).uri);
    }

    @Override
    public int compareTo(FsMountPoint fsMountPoint) {
        return this.uri.compareTo(fsMountPoint.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

