/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;
import zz.de.schlichtherle.truezip.fs.FsUriModifier;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import zz.de.schlichtherle.truezip.util.UriBuilder;

@Immutable
public final class FsPath
implements Serializable,
Comparable<FsPath> {
    private static final long serialVersionUID = 5798435461242930648L;
    private static final URI DOT = URI.create(".");
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;
    @Nullable
    private transient FsMountPoint mountPoint;
    private transient FsEntryName entryName;
    @Nullable
    private volatile transient URI hierarchical;

    @Deprecated
    public static FsPath create(String string) {
        return FsPath.create(string, FsUriModifier.NULL);
    }

    @Deprecated
    public static FsPath create(String string, FsUriModifier fsUriModifier) {
        try {
            return new FsPath(string, fsUriModifier);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static FsPath create(URI uRI) {
        return FsPath.create(uRI, FsUriModifier.NULL);
    }

    public static FsPath create(URI uRI, FsUriModifier fsUriModifier) {
        try {
            return new FsPath(uRI, fsUriModifier);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Deprecated
    public FsPath(String string) throws URISyntaxException {
        this.parse(new URI(string), FsUriModifier.NULL);
    }

    @Deprecated
    public FsPath(String string, FsUriModifier fsUriModifier) throws URISyntaxException {
        this.parse(new URI(string), fsUriModifier);
    }

    public FsPath(File file) {
        try {
            this.parse(file.toURI(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    public FsPath(URI uRI) throws URISyntaxException {
        this.parse(uRI, FsUriModifier.NULL);
    }

    public FsPath(URI uRI, FsUriModifier fsUriModifier) throws URISyntaxException {
        this.parse(uRI, fsUriModifier);
    }

    public FsPath(@CheckForNull FsMountPoint fsMountPoint, FsEntryName fsEntryName) {
        if (null == fsMountPoint) {
            this.uri = fsEntryName.toUri();
        } else if (fsEntryName.isRoot()) {
            this.uri = fsMountPoint.toUri();
        } else {
            URI uRI = fsMountPoint.toUri();
            if (uRI.isOpaque()) {
                try {
                    String string = uRI.getRawSchemeSpecificPart();
                    int n2 = string.length();
                    URI uRI2 = fsEntryName.toUri();
                    String string2 = uRI2.getRawPath();
                    int n3 = string2.length();
                    String string3 = uRI2.getRawQuery();
                    int n4 = null == string3 ? 0 : string3.length() + 1;
                    StringBuilder stringBuilder = new StringBuilder(n2 + n3 + n4).append(string).append(string2);
                    if (null != string3) {
                        stringBuilder.append('?').append(string3);
                    }
                    this.uri = new UriBuilder(true).scheme(uRI.getScheme()).path(stringBuilder.toString()).fragment(uRI2.getRawFragment()).getUri();
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new AssertionError((Object)uRISyntaxException);
                }
            } else {
                this.uri = uRI.resolve(fsEntryName.toUri());
            }
        }
        this.mountPoint = fsMountPoint;
        this.entryName = fsEntryName;
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(objectInputStream.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (InvalidObjectException)new InvalidObjectException(uRISyntaxException.toString()).initCause(uRISyntaxException);
        }
    }

    private void parse(URI uRI, FsUriModifier fsUriModifier) throws URISyntaxException {
        if (null != (uRI = fsUriModifier.modify(uRI, FsUriModifier.PostFix.PATH)).getRawFragment()) {
            throw new QuotedUriSyntaxException(uRI, "Fragment not allowed");
        }
        if (uRI.isOpaque()) {
            URI uRI2;
            URI uRI3;
            String string = uRI.getRawSchemeSpecificPart();
            int n2 = string.lastIndexOf("!/");
            if (0 > n2) {
                throw new QuotedUriSyntaxException(uRI, "Missing mount point separator \"!/\"");
            }
            UriBuilder uriBuilder = new UriBuilder(true);
            this.mountPoint = new FsMountPoint(uriBuilder.scheme(uRI.getScheme()).path(string.substring(0, n2 + 2)).toUri(), fsUriModifier);
            this.entryName = new FsEntryName(uriBuilder.clear().pathQuery(string.substring(n2 + 2)).fragment(uRI.getRawFragment()).toUri(), fsUriModifier);
            if (FsUriModifier.NULL != fsUriModifier && !uRI.equals(uRI3 = new URI((uRI2 = this.mountPoint.toUri()).getScheme() + ':' + uRI2.getRawSchemeSpecificPart() + this.entryName.toUri()))) {
                uRI = uRI3;
            }
        } else if (uRI.isAbsolute()) {
            this.mountPoint = new FsMountPoint(uRI.resolve(DOT), fsUriModifier);
            this.entryName = new FsEntryName(this.mountPoint.toUri().relativize(uRI), fsUriModifier);
        } else {
            this.mountPoint = null;
            this.entryName = new FsEntryName(uRI, fsUriModifier);
            if (FsUriModifier.NULL != fsUriModifier) {
                uRI = this.entryName.toUri();
            }
        }
        this.uri = uRI;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (null == this.toUri().getRawFragment());
        assert (null != this.getMountPoint() == this.toUri().isAbsolute());
        assert (null != this.getEntryName());
        if (this.toUri().isOpaque()) {
            assert (this.toUri().getRawSchemeSpecificPart().contains("!/"));
        } else if (this.toUri().isAbsolute()) {
            assert (this.toUri().normalize() == this.toUri());
            assert (this.toUri().equals(this.getMountPoint().toUri().resolve(this.getEntryName().toUri())));
        } else {
            assert (this.toUri().normalize() == this.toUri());
            assert (this.getEntryName().toUri() == this.toUri());
        }
        return true;
    }

    public URI toUri() {
        return this.uri;
    }

    @Deprecated
    public URI getUri() {
        return this.uri;
    }

    public URI toHierarchicalUri() {
        URI uRI = this.hierarchical;
        if (null != uRI) {
            return uRI;
        }
        if (this.uri.isOpaque()) {
            URI uRI2 = this.mountPoint.toHierarchicalUri();
            URI uRI3 = this.entryName.toUri();
            try {
                this.hierarchical = uRI3.toString().isEmpty() ? uRI2 : new UriBuilder(uRI2, true).path(uRI2.getRawPath() + "/").getUri().resolve(uRI3);
                return this.hierarchical;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AssertionError((Object)uRISyntaxException);
            }
        }
        this.hierarchical = this.uri;
        return this.hierarchical;
    }

    @Deprecated
    public URI getHierarchicalUri() {
        return this.toHierarchicalUri();
    }

    @Nullable
    public FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    public FsEntryName getEntryName() {
        return this.entryName;
    }

    public FsPath resolve(FsEntryName fsEntryName) {
        if (fsEntryName.isRoot() && null == this.uri.getQuery()) {
            return this;
        }
        return new FsPath(this.mountPoint, new FsEntryName(this.entryName, fsEntryName));
    }

    public boolean equals(@CheckForNull Object object) {
        return this == object || object instanceof FsPath && this.uri.equals(((FsPath)object).uri);
    }

    @Override
    public int compareTo(FsPath fsPath) {
        return this.uri.compareTo(fsPath.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

