/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.util.ExceptionHandler;
import zz.de.schlichtherle.truezip.util.HashMaps;

@ThreadSafe
final class FsResourceAccountant {
    private static final ConcurrentMap<Closeable, Account> accounts;
    private final Lock lock;
    private final Condition condition;

    FsResourceAccountant(Lock lock) {
        this.lock = lock;
        this.condition = this.lock.newCondition();
    }

    void startAccountingFor(@WillCloseWhenClosed Closeable closeable) {
        accounts.put(closeable, new Account());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAccountingFor(@WillNotClose Closeable closeable) {
        if (null != accounts.remove(closeable)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitClosingOfOtherThreadsResources(long l2) {
        this.lock.lock();
        try {
            try {
                if (0L < l2) {
                    long l3 = TimeUnit.MILLISECONDS.toNanos(l2);
                    while (0L < l3 && this.resources().needsWaiting()) {
                        l3 = this.condition.awaitNanos(l3);
                    }
                } else {
                    while (this.resources().needsWaiting()) {
                        this.condition.await();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (0 == this.resources().total) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Resources resources() {
        Thread thread = Thread.currentThread();
        int n2 = 0;
        int n3 = 0;
        for (Account account : accounts.values()) {
            if (account.getAccountant() != this) continue;
            if (account.owner == thread) {
                ++n2;
            }
            ++n3;
        }
        return new Resources(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <X extends Exception> void closeAllResources(ExceptionHandler<? super IOException, X> exceptionHandler) throws X {
        assert (null != exceptionHandler);
        this.lock.lock();
        try {
            Iterator iterator = accounts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Account account = (Account)entry.getValue();
                if (account.getAccountant() != this) continue;
                iterator.remove();
                Closeable closeable = (Closeable)entry.getKey();
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    exceptionHandler.warn(iOException);
                }
            }
        }
        finally {
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    static {
        int n2 = Runtime.getRuntime().availableProcessors() * 10;
        int n3 = HashMaps.initialCapacity(n2);
        accounts = new ConcurrentHashMap<Closeable, Account>(n3, 0.75f, n2);
    }

    @Immutable
    static final class Resources {
        final int local;
        final int total;

        private Resources(int n2, int n3) {
            this.local = n2;
            this.total = n3;
        }

        boolean needsWaiting() {
            return this.local < this.total;
        }
    }

    private final class Account {
        final Thread owner = Thread.currentThread();

        private Account() {
        }

        FsResourceAccountant getAccountant() {
            return FsResourceAccountant.this;
        }
    }
}

