/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.util.UriBuilder;

@Immutable
public final class FsScheme
implements Serializable,
Comparable<FsScheme> {
    private static final long serialVersionUID = 2765230379628276648L;
    private final String scheme;

    public static FsScheme create(String string) {
        try {
            return new FsScheme(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public FsScheme(String string) throws URISyntaxException {
        UriBuilder.validateScheme(string);
        this.scheme = string;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof FsScheme && this.scheme.equalsIgnoreCase(((FsScheme)object).scheme);
    }

    @Override
    public int compareTo(FsScheme fsScheme) {
        return this.scheme.compareToIgnoreCase(fsScheme.scheme);
    }

    public int hashCode() {
        return this.scheme.toLowerCase(Locale.ROOT).hashCode();
    }

    public String toString() {
        return this.scheme;
    }
}

