/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.entry.EntryContainer;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystem;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsCovariantEntry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import zz.de.schlichtherle.truezip.fs.FsFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsFileSystemArchiveController;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import zz.de.schlichtherle.truezip.fs.FsNeedsSyncException;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsOutputOptions;
import zz.de.schlichtherle.truezip.fs.FsPersistentFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncWarningException;
import zz.de.schlichtherle.truezip.io.InputClosedException;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.OutputClosedException;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.ClutchInputSocket;
import zz.de.schlichtherle.truezip.socket.ClutchOutputSocket;
import zz.de.schlichtherle.truezip.socket.DisconnectingInputShop;
import zz.de.schlichtherle.truezip.socket.DisconnectingOutputShop;
import zz.de.schlichtherle.truezip.socket.IOSocket;
import zz.de.schlichtherle.truezip.socket.InputService;
import zz.de.schlichtherle.truezip.socket.InputShop;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.LockInputShop;
import zz.de.schlichtherle.truezip.socket.LockOutputShop;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.ControlFlowException;

@NotThreadSafe
final class FsTargetArchiveController<E extends FsArchiveEntry>
extends FsFileSystemArchiveController<E>
implements FsArchiveFileSystem.TouchListener {
    private static final BitField<FsInputOption> MOUNT_INPUT_OPTIONS = BitField.of(FsInputOption.CACHE);
    private final FsArchiveDriver<E> driver;
    private final FsController<?> parent;
    private final FsEntryName name;
    @CheckForNull
    private InputArchive<E> inputArchive;
    @CheckForNull
    private OutputArchive<E> outputArchive;

    FsTargetArchiveController(FsArchiveDriver<E> fsArchiveDriver, FsLockModel fsLockModel, FsController<? extends FsModel> fsController) {
        super(fsLockModel);
        if (null == fsArchiveDriver) {
            throw new NullPointerException();
        }
        if (fsLockModel.getParent() != fsController.getModel()) {
            throw new IllegalArgumentException("Parent/member mismatch!");
        }
        this.driver = fsArchiveDriver;
        this.parent = fsController;
        this.name = this.getMountPoint().getPath().getEntryName();
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.driver);
        assert (null != this.parent);
        assert (null != this.name);
        FsArchiveFileSystem fsArchiveFileSystem = this.getFileSystem();
        InputArchive<E> inputArchive = this.inputArchive;
        OutputArchive<E> outputArchive = this.outputArchive;
        assert (null == inputArchive || null != fsArchiveFileSystem) : "null != ia => null != fs";
        assert (null == outputArchive || null != fsArchiveFileSystem) : "null != oa => null != fs";
        assert (null == fsArchiveFileSystem || null != inputArchive || null != outputArchive) : "null != fs => null != ia || null != oa";
        return true;
    }

    @Nullable
    InputArchive<E> getInputArchive() throws FsNeedsSyncException {
        InputArchive<E> inputArchive = this.inputArchive;
        if (null != inputArchive && inputArchive.isClosed()) {
            throw FsNeedsSyncException.get();
        }
        return inputArchive;
    }

    private void setInputArchive(@CheckForNull InputArchive<E> inputArchive) {
        assert (null == inputArchive || null == this.inputArchive);
        this.inputArchive = inputArchive;
        if (null != inputArchive) {
            this.setMounted(true);
        }
    }

    @Nullable
    OutputArchive<E> getOutputArchive() throws FsNeedsSyncException {
        OutputArchive<E> outputArchive = this.outputArchive;
        if (null != outputArchive && outputArchive.isClosed()) {
            throw FsNeedsSyncException.get();
        }
        return outputArchive;
    }

    private void setOutputArchive(@CheckForNull OutputArchive<E> outputArchive) {
        assert (null == outputArchive || null == this.outputArchive);
        this.outputArchive = outputArchive;
        if (null != outputArchive) {
            this.setMounted(true);
        }
    }

    @Override
    public void preTouch() throws IOException {
        this.makeOutputArchive();
    }

    @Override
    public FsController<?> getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mount(boolean bl2) throws IOException {
        try {
            this.mount0(bl2);
        }
        finally {
            assert (this.invariants());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private void mount0(boolean bl2) throws IOException {
        FsArchiveFileSystem<E> fsArchiveFileSystem;
        FsEntry fsEntry;
        try {
            fsEntry = this.parent.getEntry(this.name);
        }
        catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
            throw new AssertionError((Object)fsFalsePositiveArchiveException);
        }
        catch (IOException iOException) {
            if (!bl2) throw new FsFalsePositiveArchiveException(iOException);
            throw iOException;
        }
        if (null == fsEntry) {
            if (!bl2) throw new FsFalsePositiveArchiveException(new FsEntryNotFoundException((FsModel)this.parent.getModel(), this.name, "no such entry"));
            this.makeOutputArchive();
            fsArchiveFileSystem = FsArchiveFileSystem.newEmptyFileSystem(this.driver);
        } else {
            try {
                boolean bl3 = !this.parent.isWritable(this.name);
                InputSocket<?> inputSocket = this.driver.getInputSocket(this.parent, this.name, MOUNT_INPUT_OPTIONS);
                InputArchive<E> inputArchive = new InputArchive<E>(this.driver.newInputShop((FsModel)this.getModel(), inputSocket));
                try {
                    fsArchiveFileSystem = FsArchiveFileSystem.newPopulatedFileSystem(this.driver, inputArchive.getArchive(), fsEntry, bl3);
                }
                catch (IOException iOException) {
                    inputArchive.close();
                    throw iOException;
                }
                this.setInputArchive(inputArchive);
                assert (this.isMounted());
            }
            catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
                throw new AssertionError((Object)fsFalsePositiveArchiveException);
            }
            catch (IOException iOException) {
                throw fsEntry.isType(Entry.Type.SPECIAL) ? new FsFalsePositiveArchiveException(iOException) : new FsPersistentFalsePositiveArchiveException(iOException);
            }
        }
        fsArchiveFileSystem.setTouchListener(this);
        this.setFileSystem(fsArchiveFileSystem);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    OutputArchive<E> makeOutputArchive() throws IOException {
        OutputArchive<E> outputArchive = this.getOutputArchive();
        if (null != outputArchive) {
            assert (this.isMounted());
            return outputArchive;
        }
        BitField<FsOutputOption> bitField = this.getContext().getOutputOptions().and(FsOutputOptions.OUTPUT_PREFERENCES_MASK).set(FsOutputOption.CACHE);
        OutputSocket<?> outputSocket = this.driver.getOutputSocket(this.parent, this.name, bitField, null);
        InputArchive<E> inputArchive = this.getInputArchive();
        try {
            outputArchive = new OutputArchive<E>(this.driver.newOutputShop((FsModel)this.getModel(), outputSocket, null == inputArchive ? null : inputArchive.getArchive()));
        }
        catch (FsFalsePositiveArchiveException fsFalsePositiveArchiveException) {
            throw new AssertionError((Object)fsFalsePositiveArchiveException);
        }
        catch (ControlFlowException controlFlowException) {
            assert (controlFlowException instanceof FsNeedsLockRetryException) : controlFlowException;
            throw controlFlowException;
        }
        this.setOutputArchive(outputArchive);
        assert (this.isMounted());
        return outputArchive;
    }

    @Override
    InputSocket<? extends E> getInputSocket(final String string) {
        class Input
        extends ClutchInputSocket<E> {
            Input() {
            }

            @Override
            protected InputSocket<? extends E> getLazyDelegate() throws IOException {
                return FsTargetArchiveController.this.getInputArchive().getInputSocket(string);
            }

            @Override
            public E getLocalTarget() throws IOException {
                try {
                    return (FsArchiveEntry)this.getBoundSocket().getLocalTarget();
                }
                catch (InputClosedException inputClosedException) {
                    throw this.map(inputClosedException);
                }
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                try {
                    return this.getBoundSocket().newReadOnlyFile();
                }
                catch (InputClosedException inputClosedException) {
                    throw this.map(inputClosedException);
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                try {
                    return this.getBoundSocket().newSeekableByteChannel();
                }
                catch (InputClosedException inputClosedException) {
                    throw this.map(inputClosedException);
                }
            }

            @Override
            public InputStream newInputStream() throws IOException {
                try {
                    return this.getBoundSocket().newInputStream();
                }
                catch (InputClosedException inputClosedException) {
                    throw this.map(inputClosedException);
                }
            }

            ControlFlowException map(InputClosedException inputClosedException) {
                return FsNeedsSyncException.get();
            }
        }
        return new Input();
    }

    @Override
    OutputSocket<? extends E> getOutputSocket(E e2) {
        class Output
        extends ClutchOutputSocket<E> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
            }

            @Override
            protected OutputSocket<? extends E> getLazyDelegate() throws IOException {
                return FsTargetArchiveController.this.makeOutputArchive().getOutputSocket(this.val$entry);
            }

            @Override
            public E getLocalTarget() throws IOException {
                try {
                    return (FsArchiveEntry)this.getBoundSocket().getLocalTarget();
                }
                catch (OutputClosedException outputClosedException) {
                    throw this.map(outputClosedException);
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                try {
                    return this.getBoundSocket().newSeekableByteChannel();
                }
                catch (OutputClosedException outputClosedException) {
                    throw this.map(outputClosedException);
                }
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                try {
                    return this.getBoundSocket().newOutputStream();
                }
                catch (OutputClosedException outputClosedException) {
                    throw this.map(outputClosedException);
                }
            }

            ControlFlowException map(OutputClosedException outputClosedException) {
                return FsNeedsSyncException.get();
            }
        }
        return new Output();
    }

    @Override
    void checkSync(FsEntryName fsEntryName, @CheckForNull Entry.Access access) throws FsNeedsSyncException {
        String string;
        FsCovariantEntry fsCovariantEntry;
        FsArchiveFileSystem fsArchiveFileSystem = this.getFileSystem();
        if (null == fsArchiveFileSystem) {
            return;
        }
        if (this.getContext().get(FsOutputOption.GROW)) {
            if (null == access) {
                if (this.driver.getRedundantMetaDataSupport()) {
                    return;
                }
            } else if (Entry.Access.WRITE == access && this.driver.getRedundantContentSupport()) {
                this.getOutputArchive();
                return;
            }
        }
        if (null == (fsCovariantEntry = fsArchiveFileSystem.getEntry(fsEntryName))) {
            return;
        }
        if (fsEntryName.isRoot()) {
            return;
        }
        OutputArchive<E> outputArchive = this.getOutputArchive();
        if (null != outputArchive) {
            string = fsCovariantEntry.getEntry().getName();
            if (null != outputArchive.getEntry(string)) {
                throw FsNeedsSyncException.get();
            }
        } else {
            string = null;
        }
        if (Entry.Access.READ != access) {
            return;
        }
        InputArchive<E> inputArchive = this.getInputArchive();
        if (null != inputArchive) {
            if (null == string) {
                string = fsCovariantEntry.getEntry().getName();
            }
            outputArchive = (FsArchiveEntry)inputArchive.getEntry(string);
        } else {
            outputArchive = null;
        }
        if (null == outputArchive) {
            throw FsNeedsSyncException.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        assert (this.isWriteLockedByCurrentThread());
        try {
            FsSyncExceptionBuilder fsSyncExceptionBuilder = new FsSyncExceptionBuilder();
            if (!bitField.get(FsSyncOption.ABORT_CHANGES)) {
                this.copy(fsSyncExceptionBuilder);
            }
            this.close(bitField, fsSyncExceptionBuilder);
            fsSyncExceptionBuilder.check();
        }
        finally {
            assert (this.invariants());
        }
    }

    private void copy(FsSyncExceptionBuilder fsSyncExceptionBuilder) throws FsSyncException {
        EntryContainer<E> entryContainer = this.outputArchive;
        if (null == entryContainer || ((OutputArchive)entryContainer).isClosed()) {
            return;
        }
        assert (!((OutputArchive)entryContainer).isClosed());
        DisconnectingOutputShop<FsArchiveEntry> disconnectingOutputShop = ((OutputArchive)entryContainer).getClutch();
        InputArchive<E> inputArchive = this.inputArchive;
        if (null != inputArchive && inputArchive.isClosed()) {
            return;
        }
        assert (null == inputArchive || !inputArchive.isClosed());
        entryContainer = null != inputArchive ? inputArchive.getClutch() : new DummyInputService();
        inputArchive = null;
        for (FsCovariantEntry fsCovariantEntry : this.getFileSystem()) {
            for (FsArchiveEntry fsArchiveEntry : fsCovariantEntry.getEntries()) {
                String string = fsArchiveEntry.getName();
                if (null != disconnectingOutputShop.getEntry(string)) continue;
                try {
                    if (Entry.Type.DIRECTORY == fsArchiveEntry.getType()) {
                        if (fsCovariantEntry.isRoot() || -1L == fsArchiveEntry.getTime(Entry.Access.WRITE)) continue;
                        disconnectingOutputShop.getOutputSocket(fsArchiveEntry).newOutputStream().close();
                        continue;
                    }
                    if (null != entryContainer.getEntry(string)) {
                        IOSocket.copy(entryContainer.getInputSocket(string), disconnectingOutputShop.getOutputSocket(fsArchiveEntry));
                        continue;
                    }
                    for (Entry.Size size : Entry.ALL_SIZE_SET) {
                        fsArchiveEntry.setSize(size, -1L);
                    }
                    fsArchiveEntry.setSize(Entry.Size.DATA, 0L);
                    disconnectingOutputShop.getOutputSocket(fsArchiveEntry).newOutputStream().close();
                }
                catch (IOException iOException) {
                    if (null != inputArchive || !(iOException instanceof InputException)) {
                        throw (FsSyncException)fsSyncExceptionBuilder.fail(new FsSyncException((FsModel)this.getModel(), iOException));
                    }
                    inputArchive = iOException;
                    fsSyncExceptionBuilder.warn(new FsSyncWarningException((FsModel)this.getModel(), iOException));
                }
            }
        }
    }

    private void close(BitField<FsSyncOption> bitField, FsSyncExceptionBuilder fsSyncExceptionBuilder) {
        OutputArchive<E> outputArchive;
        InputArchive<E> inputArchive = this.inputArchive;
        if (null != inputArchive) {
            try {
                inputArchive.close();
            }
            catch (ControlFlowException controlFlowException) {
                assert (controlFlowException instanceof FsNeedsLockRetryException);
                throw controlFlowException;
            }
            catch (IOException iOException) {
                fsSyncExceptionBuilder.warn(new FsSyncWarningException((FsModel)this.getModel(), iOException));
            }
            this.setInputArchive(null);
        }
        if (null != (outputArchive = this.outputArchive)) {
            try {
                outputArchive.close();
            }
            catch (ControlFlowException controlFlowException) {
                assert (controlFlowException instanceof FsNeedsLockRetryException);
                throw controlFlowException;
            }
            catch (IOException iOException) {
                fsSyncExceptionBuilder.warn(new FsSyncException((FsModel)this.getModel(), iOException));
            }
            this.setOutputArchive(null);
        }
        this.setFileSystem(null);
        if (bitField.get(FsSyncOption.ABORT_CHANGES)) {
            this.setMounted(false);
        }
    }

    private static final class OutputArchive<E extends FsArchiveEntry>
    extends LockOutputShop<E> {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        OutputArchive(@WillCloseWhenClosed OutputShop<E> outputShop) {
            super(new DisconnectingOutputShop<E>(outputShop));
        }

        boolean isClosed() {
            return this.getClutch().isClosed();
        }

        DisconnectingOutputShop<E> getClutch() {
            return (DisconnectingOutputShop)this.delegate;
        }
    }

    private static final class InputArchive<E extends FsArchiveEntry>
    extends LockInputShop<E> {
        final InputShop<E> archive;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        InputArchive(@WillCloseWhenClosed InputShop<E> inputShop) {
            super(new DisconnectingInputShop<E>(inputShop));
            this.archive = inputShop;
        }

        boolean isClosed() {
            return this.getClutch().isClosed();
        }

        DisconnectingInputShop<E> getClutch() {
            return (DisconnectingInputShop)this.delegate;
        }

        InputShop<E> getArchive() {
            assert (!this.isClosed());
            return this.archive;
        }
    }

    private static final class DummyInputService<E extends Entry>
    implements InputService<E> {
        private DummyInputService() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        @CheckForNull
        public E getEntry(String string) {
            return null;
        }

        @Override
        public InputSocket<? extends E> getInputSocket(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

