/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriverEntry;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.IOPoolProvider;
import zz.de.schlichtherle.truezip.socket.InputShop;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.MultiplexedOutputShop;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.org.apache.commons.compress.archivers.tar.TarArchiveEntry;

@Immutable
public class TarDriver
extends FsCharsetArchiveDriver<TarDriverEntry> {
    public static final Charset TAR_CHARSET = Charset.defaultCharset();
    private final IOPool<?> ioPool;

    public TarDriver(IOPoolProvider iOPoolProvider) {
        super(TAR_CHARSET);
        this.ioPool = iOPoolProvider.get();
        if (null == this.ioPool) {
            throw new NullPointerException();
        }
    }

    final String getEncoding() {
        return this.getCharset().name();
    }

    @Override
    protected final IOPool<?> getPool() {
        return this.ioPool;
    }

    @Override
    public boolean getRedundantContentSupport() {
        return true;
    }

    @Override
    public InputSocket<?> getInputSocket(FsController<?> fsController, FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        return fsController.getInputSocket(fsEntryName, bitField.clear(FsInputOption.CACHE));
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> fsController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return fsController.getOutputSocket(fsEntryName, bitField.set(FsOutputOption.COMPRESS), entry);
    }

    @Override
    public TarDriverEntry newEntry(String string, Entry.Type type, Entry entry, BitField<FsOutputOption> bitField) throws CharConversionException {
        TarDriverEntry tarDriverEntry;
        string = TarDriver.toZipOrTarEntryName(string, type);
        if (entry instanceof TarArchiveEntry) {
            tarDriverEntry = this.newEntry(string, (TarArchiveEntry)((Object)entry));
        } else {
            tarDriverEntry = this.newEntry(string);
            if (null != entry) {
                tarDriverEntry.setModTime(entry.getTime(Entry.Access.WRITE));
                tarDriverEntry.setSize(entry.getSize(Entry.Size.DATA));
            }
        }
        return tarDriverEntry;
    }

    public TarDriverEntry newEntry(String string) {
        return new TarDriverEntry(string);
    }

    public TarDriverEntry newEntry(String string, TarArchiveEntry tarArchiveEntry) {
        return new TarDriverEntry(string, tarArchiveEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TarInputShop newInputShop(FsModel fsModel, InputSocket<?> inputSocket) throws IOException {
        if (null == fsModel) {
            throw new NullPointerException();
        }
        TarInputShop tarInputShop = null;
        InputStream inputStream = inputSocket.newInputStream();
        try {
            TarInputShop tarInputShop2 = tarInputShop = this.newTarInputShop(fsModel, inputStream);
            return tarInputShop2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                if (null != tarInputShop) {
                    tarInputShop.close();
                }
                throw iOException;
            }
        }
    }

    @CreatesObligation
    protected TarInputShop newTarInputShop(FsModel fsModel, @WillCloseWhenClosed InputStream inputStream) throws IOException {
        assert (null != fsModel);
        return new TarInputShop(this, inputStream);
    }

    @Override
    public OutputShop<TarDriverEntry> newOutputShop(FsModel fsModel, OutputSocket<?> outputSocket, InputShop<TarDriverEntry> inputShop) throws IOException {
        if (null == fsModel) {
            throw new NullPointerException();
        }
        OutputStream outputStream = outputSocket.newOutputStream();
        try {
            return new MultiplexedOutputShop<TarDriverEntry>(this.newTarOutputShop(fsModel, outputStream, (TarInputShop)inputShop), this.getPool());
        }
        catch (IOException iOException) {
            block5: {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {
                    if (!JSE7.AVAILABLE) break block5;
                    iOException.addSuppressed(iOException2);
                }
            }
            throw iOException;
        }
    }

    @CreatesObligation
    protected TarOutputShop newTarOutputShop(FsModel fsModel, OutputStream outputStream, @CheckForNull @WillNotClose TarInputShop tarInputShop) throws IOException {
        assert (null != fsModel);
        return new TarOutputShop(this, outputStream);
    }
}

