/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import java.io.IOException;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntries;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.util.Pool;
import zz.org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class TarDriverEntry
extends TarArchiveEntry
implements FsArchiveEntry,
Pool.Releasable<IOException> {
    private static final int SIZE = 1;
    private static final int MODTIME = 2;
    private byte init;
    @CheckForNull
    private IOPool.Entry<?> temp;

    public TarDriverEntry(String string) {
        super(string, true);
        super.setUserName(System.getProperty("user.name", ""));
    }

    protected TarDriverEntry(String string, TarArchiveEntry tarArchiveEntry) {
        super(string, true);
        super.setMode(tarArchiveEntry.getMode());
        this.setModTime0(tarArchiveEntry.getModTime().getTime());
        this.setSize0(tarArchiveEntry.getSize());
        super.setUserId(tarArchiveEntry.getUserId());
        super.setUserName(tarArchiveEntry.getUserName());
        super.setGroupId(tarArchiveEntry.getGroupId());
        super.setGroupName(tarArchiveEntry.getGroupName());
        super.setLinkName(tarArchiveEntry.getLinkName());
    }

    private boolean isInit(int n2) {
        return 0 != (this.init & n2);
    }

    private void setInit(int n2, boolean bl2) {
        this.init = bl2 ? (byte)(this.init | n2) : (byte)(this.init & ~n2);
    }

    @Nullable
    IOPool.Entry<?> getTemp() {
        return this.temp;
    }

    void setTemp(@CheckForNull IOPool.Entry<?> entry) {
        this.temp = entry;
    }

    @Override
    public void release() throws IOException {
        if (null == this.temp) {
            return;
        }
        this.temp.release();
        this.temp = null;
    }

    @Override
    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    public long getSize() {
        return this.isInit(1) ? super.getSize() : -1L;
    }

    @Override
    public void setSize(long l2) {
        this.setSize0(l2);
    }

    private void setSize0(long l2) {
        boolean bl2 = -1L != l2;
        super.setSize(bl2 ? l2 : 0L);
        this.setInit(1, bl2);
    }

    @Override
    public long getSize(Entry.Size size) {
        switch (size) {
            case DATA: 
            case STORAGE: {
                return this.getSize();
            }
        }
        return -1L;
    }

    @Override
    public boolean setSize(Entry.Size size, long l2) {
        if (Entry.Size.DATA != size) {
            return false;
        }
        this.setSize(l2);
        return true;
    }

    @Override
    public Date getModTime() {
        return this.isInit(2) ? super.getModTime() : new Date(-1L);
    }

    @Override
    public void setModTime(long l2) {
        this.setModTime0(l2);
    }

    private void setModTime0(long l2) {
        boolean bl2 = -1L != l2;
        super.setModTime(bl2 ? l2 : 0L);
        this.setInit(2, bl2);
    }

    @Override
    public void setModTime(Date date) {
        this.setModTime(date.getTime());
    }

    @Override
    public long getTime(Entry.Access access) {
        if (Entry.Access.WRITE != access) {
            return -1L;
        }
        long l2 = this.getModTime().getTime();
        return 0L <= l2 ? l2 : -1L;
    }

    @Override
    public boolean setTime(Entry.Access access, long l2) {
        if (Entry.Access.WRITE != access) {
            return false;
        }
        this.setModTime(l2);
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return FsArchiveEntries.toString(this);
    }
}

