/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriverEntry;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.de.schlichtherle.truezip.io.DisconnectingOutputStream;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.OutputBusyException;
import zz.de.schlichtherle.truezip.io.SequentialIOException;
import zz.de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import zz.de.schlichtherle.truezip.io.Streams;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@NotThreadSafe
public class TarOutputShop
extends TarArchiveOutputStream
implements OutputShop<TarDriverEntry> {
    public static final int OVERHEAD_SIZE = 47;
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity(47));
    private final IOPool<?> pool;
    private boolean busy;

    @CreatesObligation
    public TarOutputShop(TarDriver tarDriver, @WillCloseWhenClosed OutputStream outputStream) {
        super(outputStream, 10240, 512, tarDriver.getEncoding());
        super.setAddPaxHeadersForNonAsciiNames(true);
        super.setLongFileMode(3);
        super.setBigNumberMode(2);
        this.pool = tarDriver.getPool();
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @Override
    @CheckForNull
    public TarDriverEntry getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public OutputSocket<TarDriverEntry> getOutputSocket(final TarDriverEntry tarDriverEntry) {
        if (null == tarDriverEntry) {
            throw new NullPointerException();
        }
        final class Output
        extends OutputSocket<TarDriverEntry> {
            Output() {
            }

            @Override
            public TarDriverEntry getLocalTarget() {
                return tarDriverEntry;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (TarOutputShop.this.isBusy()) {
                    throw new OutputBusyException(tarDriverEntry.getName());
                }
                if (tarDriverEntry.isDirectory()) {
                    TarOutputShop.this.updateProperties(tarDriverEntry, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(tarDriverEntry);
                }
                TarOutputShop.this.updateProperties(tarDriverEntry, this.getPeerTarget());
                return -1L == tarDriverEntry.getSize() ? new BufferedEntryOutputStream(tarDriverEntry) : new EntryOutputStream(tarDriverEntry);
            }
        }
        return new Output();
    }

    void updateProperties(TarDriverEntry tarDriverEntry, @CheckForNull Entry entry) {
        if (-1L == tarDriverEntry.getModTime().getTime()) {
            tarDriverEntry.setModTime(System.currentTimeMillis());
        }
        if (null != entry && -1L == tarDriverEntry.getSize()) {
            tarDriverEntry.setSize(entry.getSize(Entry.Size.DATA));
        }
    }

    private boolean isBusy() {
        return this.busy;
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IOPool.Entry<?> buffer;
        final TarDriverEntry local;
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        BufferedEntryOutputStream(TarDriverEntry tarDriverEntry) throws IOException {
            super(null);
            this.local = tarDriverEntry;
            IOPool.Entry entry = this.buffer = (IOPool.Entry)TarOutputShop.this.pool.allocate();
            try {
                this.delegate = entry.getOutputSocket().newOutputStream();
            }
            catch (IOException iOException) {
                block4: {
                    try {
                        entry.release();
                    }
                    catch (IOException iOException2) {
                        if (!JSE7.AVAILABLE) break block4;
                        iOException.addSuppressed(iOException2);
                    }
                }
                throw iOException;
            }
            TarOutputShop.this.entries.put(tarDriverEntry.getName(), tarDriverEntry);
            TarOutputShop.this.busy = true;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputShop.this.busy = false;
            this.delegate.close();
            TarOutputShop.this.updateProperties(this.local, this.buffer);
            this.storeBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeBuffer() throws IOException {
            IOPool.Entry<?> entry = this.buffer;
            SequentialIOExceptionBuilder<IOException, SequentialIOException> sequentialIOExceptionBuilder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
            try {
                InputStream inputStream = entry.getInputSocket().newInputStream();
                try {
                    TarOutputShop tarOutputShop = TarOutputShop.this;
                    tarOutputShop.putArchiveEntry(this.local);
                    try {
                        Streams.cat(inputStream, tarOutputShop);
                    }
                    catch (InputException inputException) {
                        sequentialIOExceptionBuilder.warn(inputException);
                    }
                    try {
                        tarOutputShop.closeArchiveEntry();
                    }
                    catch (IOException iOException) {
                        sequentialIOExceptionBuilder.warn(iOException);
                    }
                }
                catch (IOException iOException) {
                    sequentialIOExceptionBuilder.warn(iOException);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        sequentialIOExceptionBuilder.warn(iOException);
                    }
                }
            }
            finally {
                try {
                    entry.release();
                }
                catch (IOException iOException) {
                    sequentialIOExceptionBuilder.warn(iOException);
                }
            }
            sequentialIOExceptionBuilder.check();
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(TarDriverEntry tarDriverEntry) throws IOException {
            super(TarOutputShop.this);
            TarOutputShop.this.putArchiveEntry(tarDriverEntry);
            TarOutputShop.this.entries.put(tarDriverEntry.getName(), tarDriverEntry);
            TarOutputShop.this.busy = true;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputShop.this.busy = false;
            TarOutputShop.this.closeArchiveEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public long getSize(Entry.Size size) {
            return 0L;
        }

        @Override
        public long getTime(Entry.Access access) {
            return -1L;
        }
    }
}

