/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.archive.tar.FixedBufferedOutputStream;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import zz.de.schlichtherle.truezip.socket.IOPoolProvider;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.org.tukaani.xz.LZMA2Options;
import zz.org.tukaani.xz.XZInputStream;
import zz.org.tukaani.xz.XZOutputStream;

@Immutable
public class TarXZDriver
extends TarDriver {
    public static final int BUFFER_SIZE = 8192;

    public TarXZDriver(IOPoolProvider iOPoolProvider) {
        super(iOPoolProvider);
    }

    public int getBufferSize() {
        return 8192;
    }

    public int getPreset() {
        return 6;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> fsController, FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return fsController.getOutputSocket(fsEntryName, bitField.set(FsOutputOption.STORE), entry);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel fsModel, InputStream inputStream) throws IOException {
        return super.newTarInputShop(fsModel, new XZInputStream(new BufferedInputStream(inputStream, this.getBufferSize())));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel fsModel, OutputStream outputStream, TarInputShop tarInputShop) throws IOException {
        return super.newTarOutputShop(fsModel, new FixedXZOutputStream(new FixedBufferedOutputStream(outputStream, this.getBufferSize()), new LZMA2Options(this.getPreset())), tarInputShop);
    }

    private static final class FixedXZOutputStream
    extends XZOutputStream {
        final FixedBufferedOutputStream out;

        private FixedXZOutputStream(FixedBufferedOutputStream fixedBufferedOutputStream, LZMA2Options lZMA2Options) throws IOException {
            super((OutputStream)fixedBufferedOutputStream, lZMA2Options);
            this.out = fixedBufferedOutputStream;
        }

        @Override
        public void close() throws IOException {
            this.out.ignoreClose = true;
            super.close();
            this.out.ignoreClose = false;
            this.out.close();
        }
    }
}

