/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.zip;

import java.io.IOException;
import java.net.URI;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsCovariantEntry;
import zz.de.schlichtherle.truezip.fs.FsDecoratingController;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import zz.de.schlichtherle.truezip.key.KeyManager;
import zz.de.schlichtherle.truezip.key.KeyProvider;
import zz.de.schlichtherle.truezip.key.SafeKeyManager;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.ControlFlowException;

@Immutable
public abstract class KeyController<M extends FsModel, D extends ZipDriver>
extends FsDecoratingController<M, FsController<? extends M>> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();
    protected final D driver;
    private volatile KeyManager<?> manager;

    protected KeyController(FsController<? extends M> fsController, D d2) {
        super(fsController);
        if (null == d2) {
            throw new NullPointerException();
        }
        this.driver = d2;
    }

    protected abstract Class<?> getKeyType();

    protected abstract Class<? extends IOException> getKeyExceptionType();

    private KeyManager<?> getKeyManager() {
        KeyManager<?> keyManager = this.manager;
        return null != keyManager ? keyManager : (this.manager = ((ZipDriver)this.driver).getKeyManagerProvider().get(this.getKeyType()));
    }

    @Override
    public FsEntry getEntry(FsEntryName fsEntryName) throws IOException {
        try {
            return this.delegate.getEntry(fsEntryName);
        }
        catch (ControlFlowException controlFlowException) {
            if (!fsEntryName.isRoot() || null == this.findKeyException(controlFlowException)) {
                throw controlFlowException;
            }
            FsEntry fsEntry = this.getParent().getEntry(((FsModel)this.getModel()).getMountPoint().getPath().resolve(fsEntryName).getEntryName());
            if (null == fsEntry) {
                return null;
            }
            while (fsEntry instanceof FsCovariantEntry) {
                fsEntry = ((FsCovariantEntry)fsEntry).getEntry();
            }
            FsCovariantEntry fsCovariantEntry = new FsCovariantEntry(ROOT_PATH);
            fsCovariantEntry.put(Entry.Type.SPECIAL, ((FsArchiveDriver)this.driver).newEntry(ROOT_PATH, Entry.Type.SPECIAL, fsEntry));
            return fsCovariantEntry;
        }
    }

    @Override
    public void unlink(FsEntryName fsEntryName, BitField<FsOutputOption> bitField) throws IOException {
        try {
            this.delegate.unlink(fsEntryName, bitField);
        }
        catch (ControlFlowException controlFlowException) {
            IOException iOException = this.findKeyException(controlFlowException);
            if (null != iOException) {
                throw iOException;
            }
            throw controlFlowException;
        }
        if (fsEntryName.isRoot()) {
            this.getKeyManager().removeKeyProvider(((ZipDriver)this.driver).resourceUri((FsModel)this.getModel(), fsEntryName.toString()));
        }
    }

    @CheckForNull
    private IOException findKeyException(Throwable throwable) {
        Class<IOException> clazz = this.getKeyExceptionType();
        do {
            if (!clazz.isInstance(throwable)) continue;
            return clazz.cast(throwable);
        } while (null != (throwable = throwable.getCause()));
        return null;
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) throws FsSyncException {
        this.delegate.sync(bitField);
        KeyManager<?> keyManager = this.getKeyManager();
        URI uRI = ((ZipDriver)this.driver).mountPointUri((FsModel)this.getModel());
        KeyProvider<Object> keyProvider = keyManager instanceof SafeKeyManager ? ((SafeKeyManager)keyManager).getMappedKeyProvider(uRI) : keyManager.getKeyProvider(uRI);
        if (null != keyProvider) {
            ((ZipDriver)this.driver).getKeyProviderSyncStrategy().sync(keyProvider);
        }
    }
}

