/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.zip;

import java.net.URI;
import java.nio.charset.Charset;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import zz.de.schlichtherle.truezip.key.KeyManager;
import zz.de.schlichtherle.truezip.key.KeyProvider;
import zz.de.schlichtherle.truezip.key.UnknownKeyException;
import zz.de.schlichtherle.truezip.key.pbe.AesPbeParameters;
import zz.de.schlichtherle.truezip.zip.WinZipAesParameters;
import zz.de.schlichtherle.truezip.zip.ZipCryptoParameters;
import zz.de.schlichtherle.truezip.zip.ZipKeyException;
import zz.de.schlichtherle.truezip.zip.ZipParameters;
import zz.de.schlichtherle.truezip.zip.ZipParametersProvider;
import zz.org.bouncycastle.crypto.PBEParametersGenerator;

@ThreadSafe
public class KeyManagerZipCryptoParameters
implements ZipCryptoParameters,
ZipParametersProvider {
    private final ZipDriver driver;
    private final FsModel model;
    protected final Charset charset;

    public KeyManagerZipCryptoParameters(ZipDriver zipDriver, FsModel fsModel, Charset charset) {
        if (null == zipDriver || null == fsModel || null == charset) {
            throw new NullPointerException();
        }
        this.driver = zipDriver;
        this.model = fsModel;
        this.charset = charset;
    }

    @Override
    public <P extends ZipParameters> P get(Class<P> clazz) {
        if (clazz.isAssignableFrom(WinZipAesParameters.class)) {
            return (P)((ZipParameters)clazz.cast(new WinZipAes()));
        }
        return null;
    }

    protected byte[] password(char[] cArray, String string) {
        return PBEParametersGenerator.PKCS5PasswordToBytes((char[])cArray);
    }

    private <K> KeyManager<K> keyManager(Class<K> clazz) {
        return this.driver.getKeyManagerProvider().get(clazz);
    }

    private URI resourceUri(String string) {
        return this.driver.resourceUri(this.model, string);
    }

    private class WinZipAes
    implements WinZipAesParameters {
        final KeyManager<AesPbeParameters> manager;

        private WinZipAes() {
            this.manager = KeyManagerZipCryptoParameters.this.keyManager(AesPbeParameters.class);
        }

        @Override
        public byte[] getWritePassword(String string) throws ZipKeyException {
            KeyProvider<AesPbeParameters> keyProvider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(string));
            try {
                return KeyManagerZipCryptoParameters.this.password(keyProvider.getWriteKey().getPassword(), string);
            }
            catch (UnknownKeyException unknownKeyException) {
                throw new ZipKeyException(unknownKeyException);
            }
        }

        @Override
        public byte[] getReadPassword(String string, boolean bl2) throws ZipKeyException {
            KeyProvider<AesPbeParameters> keyProvider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(string));
            try {
                return KeyManagerZipCryptoParameters.this.password(keyProvider.getReadKey(bl2).getPassword(), string);
            }
            catch (UnknownKeyException unknownKeyException) {
                throw new ZipKeyException(unknownKeyException);
            }
        }

        @Override
        public AesKeyStrength getKeyStrength(String string) throws ZipKeyException {
            KeyProvider<AesPbeParameters> keyProvider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(string));
            try {
                return (AesKeyStrength)keyProvider.getWriteKey().getKeyStrength();
            }
            catch (UnknownKeyException unknownKeyException) {
                throw new ZipKeyException(unknownKeyException);
            }
        }

        @Override
        public void setKeyStrength(String string, AesKeyStrength aesKeyStrength) throws ZipKeyException {
            AesPbeParameters aesPbeParameters;
            KeyProvider<AesPbeParameters> keyProvider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(string));
            try {
                aesPbeParameters = keyProvider.getReadKey(false);
            }
            catch (UnknownKeyException unknownKeyException) {
                throw new ZipKeyException(unknownKeyException);
            }
            aesPbeParameters.setKeyStrength(aesKeyStrength);
            keyProvider.setKey(aesPbeParameters);
        }
    }
}

