/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.MultiplexedOutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;

@NotThreadSafe
public class OdfOutputShop
extends MultiplexedOutputShop<ZipDriverEntry> {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public OdfOutputShop(@WillCloseWhenClosed ZipOutputShop zipOutputShop, IOPool<?> iOPool) {
        super(zipOutputShop, iOPool);
    }

    @Override
    public OutputSocket<ZipDriverEntry> getOutputSocket(final ZipDriverEntry zipDriverEntry) {
        if (null == zipDriverEntry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<ZipDriverEntry> {
            Output() {
                super(OdfOutputShop.super.getOutputSocket(zipDriverEntry2));
            }

            @Override
            public ZipDriverEntry getLocalTarget() throws IOException {
                return zipDriverEntry;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (OdfOutputShop.MIMETYPE.equals(zipDriverEntry.getName())) {
                    OdfOutputShop.this.mimetype = true;
                    if (-1 == zipDriverEntry.getMethod()) {
                        zipDriverEntry.setMethod(0);
                    }
                }
                return super.newOutputStream();
            }
        }
        return new Output();
    }

    @Override
    public boolean isBusy() {
        return !this.mimetype || super.isBusy();
    }

    @Override
    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

