/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.zip;

import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntries;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.zip.DateTimeConverter;
import zz.de.schlichtherle.truezip.zip.ZipEntry;

public class ZipDriverEntry
extends ZipEntry
implements FsArchiveEntry {
    public ZipDriverEntry(String string) {
        super(string);
    }

    protected ZipDriverEntry(String string, ZipEntry zipEntry) {
        super(string, zipEntry);
    }

    @Override
    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    protected DateTimeConverter getDateTimeConverter() {
        return DateTimeConverter.ZIP;
    }

    @Override
    public long getSize(Entry.Size size) {
        switch (size) {
            case DATA: {
                return this.getSize();
            }
            case STORAGE: {
                return this.getCompressedSize();
            }
        }
        return -1L;
    }

    @Override
    public boolean setSize(Entry.Size size, long l2) {
        if (Entry.Size.DATA != size) {
            return false;
        }
        this.setSize(l2);
        return true;
    }

    @Override
    public long getTime(Entry.Access access) {
        if (Entry.Access.WRITE != access) {
            return -1L;
        }
        long l2 = this.getTime();
        return 0L <= l2 ? l2 : -1L;
    }

    @Override
    public boolean setTime(Entry.Access access, long l2) {
        if (Entry.Access.WRITE != access) {
            return false;
        }
        this.setTime(l2);
        return true;
    }

    @Override
    public String toString() {
        return FsArchiveEntries.toString(this);
    }
}

