/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsAbstractController;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.file.FileEntry;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;

@Immutable
final class FileController
extends FsAbstractController<FsModel> {
    private static final String TWO_SEPARATORS = "//";
    private final File target;

    FileController(FsModel fsModel) {
        super(fsModel);
        if (null != fsModel.getParent()) {
            throw new IllegalArgumentException();
        }
        URI uRI = fsModel.getMountPoint().toUri();
        if ('\\' == File.separatorChar && null != uRI.getRawAuthority()) {
            try {
                uRI = new URI(uRI.getScheme(), "", TWO_SEPARATORS + uRI.getAuthority() + uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AssertionError((Object)uRISyntaxException);
            }
        }
        this.target = new File(uRI);
    }

    @Override
    public FsController<?> getParent() {
        return null;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return false;
    }

    @Override
    public FileEntry getEntry(FsEntryName fsEntryName) throws IOException {
        FileEntry fileEntry = new FileEntry(this.target, fsEntryName);
        return fileEntry.getFile().exists() ? fileEntry : null;
    }

    @Override
    public boolean isReadable(FsEntryName fsEntryName) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        return file.canRead();
    }

    @Override
    public boolean isWritable(FsEntryName fsEntryName) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        return file.canWrite();
    }

    @Override
    public boolean isExecutable(FsEntryName fsEntryName) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        return file.canExecute();
    }

    @Override
    public void setReadOnly(FsEntryName fsEntryName) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        if (!file.setReadOnly()) {
            if (file.exists()) {
                throw new IOException(file + " (access denied)");
            }
            throw new FileNotFoundException(file.toString());
        }
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, Map<Entry.Access, Long> map, BitField<FsOutputOption> bitField) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        boolean bl2 = true;
        for (Map.Entry<Entry.Access, Long> entry : map.entrySet()) {
            bl2 &= Entry.Access.WRITE == entry.getKey() && file.setLastModified(entry.getValue());
        }
        return bl2;
    }

    @Override
    public boolean setTime(FsEntryName fsEntryName, BitField<Entry.Access> bitField, long l2, BitField<FsOutputOption> bitField2) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        boolean bl2 = true;
        for (Entry.Access access : bitField) {
            bl2 &= Entry.Access.WRITE == access && file.setLastModified(l2);
        }
        return bl2;
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName fsEntryName, BitField<FsInputOption> bitField) {
        return new FileEntry(this.target, fsEntryName).getInputSocket();
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName fsEntryName, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return new FileEntry(this.target, fsEntryName).getOutputSocket(bitField, entry);
    }

    @Override
    public void mknod(FsEntryName fsEntryName, Entry.Type type, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) throws IOException {
        long l2;
        File file = new File(this.target, fsEntryName.getPath());
        switch (type) {
            case FILE: {
                if (bitField.get(FsOutputOption.EXCLUSIVE)) {
                    if (file.createNewFile()) break;
                    throw new IOException(file + " (file exists already)");
                }
                new FileOutputStream(file).close();
                break;
            }
            case DIRECTORY: {
                if (file.mkdir()) break;
                if (file.exists()) {
                    throw new IOException(file + " (directory exists already)");
                }
                throw new IOException(file.toString());
            }
            default: {
                throw new IOException(file + " (entry type not supported: " + (Object)((Object)type) + ")");
            }
        }
        if (null != entry && -1L != (l2 = entry.getTime(Entry.Access.WRITE)) && !file.setLastModified(l2)) {
            throw new IOException(file + " (cannot set last modification time)");
        }
    }

    @Override
    public void unlink(FsEntryName fsEntryName, BitField<FsOutputOption> bitField) throws IOException {
        File file = new File(this.target, fsEntryName.getPath());
        if (!file.delete()) {
            throw new IOException(file + " (cannot delete)");
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> bitField) {
    }
}

