/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.file;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsOutputOptions;
import zz.de.schlichtherle.truezip.fs.file.FileInputSocket;
import zz.de.schlichtherle.truezip.fs.file.FileOutputSocket;
import zz.de.schlichtherle.truezip.fs.file.TempFilePool;
import zz.de.schlichtherle.truezip.socket.IOEntry;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.Pool;

@Immutable
class FileEntry
extends FsEntry
implements IOEntry<FileEntry>,
Pool.Releasable<IOException> {
    private static final File CURRENT_DIRECTORY = new File(".");
    private final File file;
    private final String name;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    volatile TempFilePool pool;

    FileEntry(File file) {
        assert (null != file);
        this.file = file;
        this.name = file.toString();
    }

    FileEntry(File file, FsEntryName fsEntryName) {
        assert (null != file);
        this.file = new File(file, fsEntryName.getPath());
        this.name = fsEntryName.toString();
    }

    final FileEntry createTempFile() throws IOException {
        TempFilePool tempFilePool = this.pool;
        if (null == tempFilePool) {
            this.pool = tempFilePool = new TempFilePool(this.getParent(), this.getFileName());
        }
        return tempFilePool.allocate();
    }

    private File getParent() {
        File file = this.file.getParentFile();
        return null != file ? file : CURRENT_DIRECTORY;
    }

    private String getFileName() {
        return this.file.getName();
    }

    @Override
    public void release() throws IOException {
    }

    final File getFile() {
        return this.file;
    }

    @Override
    public final String getName() {
        return this.name.replace(File.separatorChar, '/');
    }

    @Override
    public final Set<Entry.Type> getTypes() {
        if (this.file.isFile()) {
            return FILE_TYPE_SET;
        }
        if (this.file.isDirectory()) {
            return DIRECTORY_TYPE_SET;
        }
        if (this.file.exists()) {
            return SPECIAL_TYPE_SET;
        }
        return Collections.emptySet();
    }

    @Override
    public final boolean isType(Entry.Type type) {
        switch (type) {
            case FILE: {
                return this.file.isFile();
            }
            case DIRECTORY: {
                return this.file.isDirectory();
            }
            case SPECIAL: {
                return this.file.exists() && !this.file.isFile() && !this.file.isDirectory();
            }
        }
        return false;
    }

    @Override
    public final long getSize(Entry.Size size) {
        return this.file.exists() ? this.file.length() : -1L;
    }

    @Override
    public final long getTime(Entry.Access access) {
        return Entry.Access.WRITE == access && this.file.exists() ? this.file.lastModified() : -1L;
    }

    @Override
    @Nullable
    public final Set<String> getMembers() {
        String[] stringArray = this.file.list();
        return null == stringArray ? null : new HashSet<String>(Arrays.asList(stringArray));
    }

    @Override
    public final InputSocket<FileEntry> getInputSocket() {
        return new FileInputSocket(this);
    }

    @Override
    public final OutputSocket<FileEntry> getOutputSocket() {
        return new FileOutputSocket(this, FsOutputOptions.NONE, null);
    }

    final OutputSocket<FileEntry> getOutputSocket(BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return new FileOutputSocket(this, bitField, entry);
    }
}

