/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.file;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.file.FileEntry;
import zz.de.schlichtherle.truezip.io.IOExceptionOutputStream;
import zz.de.schlichtherle.truezip.socket.IOSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;

@NotThreadSafe
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(FileEntry fileEntry, BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        assert (null != fileEntry);
        assert (null != bitField);
        if (bitField.get(FsOutputOption.EXCLUSIVE) && bitField.get(FsOutputOption.APPEND)) {
            throw new IllegalArgumentException();
        }
        this.entry = fileEntry;
        this.options = bitField;
        this.template = entry;
    }

    @Override
    public FileEntry getLocalTarget() {
        return this.entry;
    }

    private FileEntry begin() throws IOException {
        File file;
        FileEntry fileEntry;
        File file2 = this.entry.getFile();
        Boolean bl2 = null;
        if (this.options.get(FsOutputOption.EXCLUSIVE) && (bl2 = Boolean.valueOf(file2.exists())).booleanValue()) {
            throw new IOException(file2 + " (file exists already)");
        }
        if (this.options.get(FsOutputOption.CACHE)) {
            if (Boolean.TRUE.equals(bl2) || null == bl2 && (bl2 = Boolean.valueOf(file2.exists())).booleanValue()) {
                if (!file2.canWrite()) {
                    throw new FileNotFoundException(file2 + " (cannot write)");
                }
            } else if (!file2.createNewFile()) {
                throw new FileNotFoundException(file2 + " (already exists)");
            }
            fileEntry = this.entry.createTempFile();
        } else {
            fileEntry = this.entry;
        }
        if (this.options.get(FsOutputOption.CREATE_PARENTS) && !Boolean.TRUE.equals(bl2) && null != (file = file2.getParentFile()) && !file.mkdirs() && !file.isDirectory()) {
            throw new IOException(file + " (cannot create directories)");
        }
        return fileEntry;
    }

    private void append(FileEntry fileEntry) throws IOException {
        if (fileEntry != this.entry && this.options.get(FsOutputOption.APPEND) && this.entry.getFile().exists()) {
            IOSocket.copy(this.entry.getInputSocket(), fileEntry.getOutputSocket());
        }
    }

    private void close(FileEntry fileEntry, boolean bl2) throws IOException {
        File file = this.entry.getFile();
        if (fileEntry != this.entry) {
            File file2 = fileEntry.getFile();
            this.copyAttributes(file2);
            if (bl2) {
                if (!FileOutputSocket.move(file2, file)) {
                    IOSocket.copy(fileEntry.getInputSocket(), this.entry.getOutputSocket());
                    this.copyAttributes(file);
                }
                this.release(fileEntry, null);
            }
        } else {
            this.copyAttributes(file);
        }
    }

    private void copyAttributes(File file) throws IOException {
        Entry entry = this.template;
        if (null == entry) {
            return;
        }
        long l2 = entry.getTime(Entry.Access.WRITE);
        if (-1L != l2 && !file.setLastModified(l2)) {
            throw new IOException(file + " (cannot preserve last modification time)");
        }
    }

    private static boolean move(File file, File file2) {
        return file.exists() && (!file2.exists() || file2.delete()) && file.renameTo(file2);
    }

    private void release(FileEntry fileEntry, @CheckForNull IOException iOException) throws IOException {
        try {
            fileEntry.release();
        }
        catch (IOException iOException2) {
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    @Override
    public OutputStream newOutputStream() throws IOException {
        final FileEntry fileEntry = this.begin();
        try {
            this.append(fileEntry);
            class OutputStream
            extends IOExceptionOutputStream {
                boolean closed;

                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                OutputStream() throws FileNotFoundException {
                    super(new FileOutputStream(fileEntry2.getFile(), FileOutputSocket.this.options.get(FsOutputOption.APPEND)));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(fileEntry, null == this.exception);
                }
            }
            return new OutputStream();
        }
        catch (IOException iOException) {
            this.release(fileEntry, iOException);
            throw iOException;
        }
    }
}

