/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.file;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.fs.file.FileEntry;
import zz.de.schlichtherle.truezip.socket.IOPool;

@ThreadSafe
final class TempFilePool
implements IOPool<FileEntry> {
    static final TempFilePool INSTANCE = new TempFilePool(null, null);
    @Nullable
    private final File dir;
    private final String prefix;

    TempFilePool(@CheckForNull File file, @CheckForNull String string) {
        this.dir = file;
        this.prefix = null != string ? TempFilePool.prefixPlusDot(string) : "tzp";
    }

    private static String prefixPlusDot(String string) {
        return string.endsWith(".") ? string : string + ".";
    }

    @Override
    public Buffer allocate() throws IOException {
        return new Buffer(this.createTempFile(), this);
    }

    private File createTempFile() throws IOException {
        try {
            return File.createTempFile(this.prefix, null, this.dir);
        }
        catch (IOException iOException) {
            if (this.dir.exists()) {
                throw iOException;
            }
            this.createTempDir();
            return this.createTempFile();
        }
    }

    private void createTempDir() {
        assert (!this.dir.exists());
        if (!this.dir.mkdirs() && !this.dir.exists()) {
            throw new IllegalArgumentException(this.dir + " (cannot create directory for temporary files)");
        }
        assert (this.dir.exists());
    }

    @Override
    public void release(IOPool.Entry<FileEntry> entry) throws IOException {
        entry.release();
    }

    @NotThreadSafe
    private static final class Buffer
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        Buffer(File file, TempFilePool tempFilePool) {
            super(file);
            assert (null != file);
            assert (null != tempFilePool);
            this.pool = tempFilePool;
        }

        @Override
        public void release() throws IOException {
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool tempFilePool) throws IOException {
            File file;
            TempFilePool tempFilePool2 = this.pool;
            this.pool = tempFilePool;
            if (tempFilePool2 != tempFilePool && !(file = this.getFile()).delete() && file.exists()) {
                throw new IOException(file + " (cannot delete temporary file)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

