/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.nio.file;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsOutputOptions;
import zz.de.schlichtherle.truezip.fs.nio.file.FileInputSocket;
import zz.de.schlichtherle.truezip.fs.nio.file.FileOutputSocket;
import zz.de.schlichtherle.truezip.fs.nio.file.TempFilePool;
import zz.de.schlichtherle.truezip.socket.IOEntry;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.Pool;

@Immutable
class FileEntry
extends FsEntry
implements IOEntry<FileEntry>,
Pool.Releasable<IOException> {
    private static final Path CURRENT_DIRECTORY = Paths.get(".", new String[0]);
    private final Path path;
    private final String name;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    volatile TempFilePool pool;

    FileEntry(Path path) {
        assert (null != path);
        this.path = path;
        this.name = path.toString();
    }

    FileEntry(Path path, FsEntryName fsEntryName) {
        assert (null != path);
        this.path = path.resolve(fsEntryName.getPath());
        this.name = fsEntryName.toString();
    }

    private BasicFileAttributes readBasicFileAttributes() throws IOException {
        return Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
    }

    final FileEntry createTempFile() throws IOException {
        TempFilePool tempFilePool = this.pool;
        if (null == tempFilePool) {
            this.pool = tempFilePool = new TempFilePool(this.getParent(), this.getFileName());
        }
        return tempFilePool.allocate();
    }

    private Path getParent() {
        Path path = this.path.getParent();
        return null != path ? path : CURRENT_DIRECTORY;
    }

    private String getFileName() {
        Path path = this.path.getFileName();
        return null != path ? path.toString() : "";
    }

    @Override
    public void release() throws IOException {
    }

    final Path getPath() {
        return this.path;
    }

    @Override
    public final String getName() {
        return this.name.replace(File.separatorChar, '/');
    }

    @Override
    public final Set<Entry.Type> getTypes() {
        try {
            BasicFileAttributes basicFileAttributes = this.readBasicFileAttributes();
            if (basicFileAttributes.isRegularFile()) {
                return FILE_TYPE_SET;
            }
            if (basicFileAttributes.isDirectory()) {
                return DIRECTORY_TYPE_SET;
            }
            if (basicFileAttributes.isSymbolicLink()) {
                return SYMLINK_TYPE_SET;
            }
            if (basicFileAttributes.isOther()) {
                return SPECIAL_TYPE_SET;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @Override
    public final boolean isType(Entry.Type type) {
        try {
            switch (type) {
                case FILE: {
                    return this.readBasicFileAttributes().isRegularFile();
                }
                case DIRECTORY: {
                    return this.readBasicFileAttributes().isDirectory();
                }
                case SYMLINK: {
                    return this.readBasicFileAttributes().isSymbolicLink();
                }
                case SPECIAL: {
                    return this.readBasicFileAttributes().isOther();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public final long getSize(Entry.Size size) {
        try {
            return this.readBasicFileAttributes().size();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public final long getTime(Entry.Access access) {
        try {
            BasicFileAttributes basicFileAttributes = this.readBasicFileAttributes();
            switch (access) {
                case WRITE: {
                    return basicFileAttributes.lastModifiedTime().toMillis();
                }
                case READ: {
                    return basicFileAttributes.lastAccessTime().toMillis();
                }
                case CREATE: {
                    return basicFileAttributes.creationTime().toMillis();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final Set<String> getMembers() {
        LinkedHashSet<String> linkedHashSet;
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.path);
        try {
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
            for (Path path : directoryStream) {
                linkedHashSet2.add(path.getFileName().toString());
            }
            linkedHashSet = linkedHashSet2;
        }
        catch (Throwable throwable) {
            try {
                directoryStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        directoryStream.close();
        return linkedHashSet;
    }

    @Override
    public final InputSocket<FileEntry> getInputSocket() {
        return new FileInputSocket(this);
    }

    @Override
    public final OutputSocket<FileEntry> getOutputSocket() {
        return new FileOutputSocket(this, FsOutputOptions.NONE, null);
    }

    final OutputSocket<FileEntry> getOutputSocket(BitField<FsOutputOption> bitField, @CheckForNull Entry entry) {
        return new FileOutputSocket(this, bitField, entry);
    }
}

