/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.fs.nio.file.FileEntry;
import zz.de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.InputSocket;

@ThreadSafe
final class FileInputSocket
extends InputSocket<FileEntry> {
    private final FileEntry entry;

    FileInputSocket(FileEntry fileEntry) {
        assert (null != fileEntry);
        this.entry = fileEntry;
    }

    @Override
    public FileEntry getLocalTarget() {
        return this.entry;
    }

    @Override
    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        return Files.newByteChannel(this.entry.getPath(), new OpenOption[0]);
    }

    @Override
    public ReadOnlyFile newReadOnlyFile() throws IOException {
        return new DefaultReadOnlyFile(this.entry.getPath().toFile());
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.entry.getPath(), new OpenOption[0]);
    }
}

