/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.spi;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsDriverProvider;
import zz.de.schlichtherle.truezip.fs.FsScheme;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.util.ServiceLocator;
import zz.de.schlichtherle.truezip.util.SuffixSet;

public abstract class FsDriverService
implements FsDriverProvider {
    public String toString() {
        return this.getClass().getName();
    }

    public static Map<FsScheme, FsDriver> newMap(Object[][] objectArray) {
        HashMap<FsScheme, FsDriver> hashMap = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity(objectArray.length) * 2);
        for (Object[] objectArray2 : objectArray) {
            Collection<FsScheme> collection = FsDriverService.toSchemes(objectArray2[0]);
            FsDriver fsDriver = ServiceLocator.promote(objectArray2[1], FsDriver.class);
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("No file system schemes for " + fsDriver);
            }
            for (FsScheme fsScheme : collection) {
                FsDriver fsDriver2 = hashMap.put(fsScheme, fsDriver);
                if (null == fsDriver2 || null == fsDriver || fsDriver2.getPriority() <= fsDriver.getPriority()) continue;
                hashMap.put(fsScheme, fsDriver2);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static Collection<FsScheme> toSchemes(Object object) {
        TreeSet<FsScheme> treeSet = new TreeSet<FsScheme>();
        try {
            if (object instanceof Collection) {
                for (Object e2 : (Collection)object) {
                    if (e2 instanceof FsScheme) {
                        treeSet.add((FsScheme)e2);
                        continue;
                    }
                    for (String string : new SuffixSet(e2.toString())) {
                        treeSet.add(new FsScheme(string));
                    }
                }
            } else if (object instanceof FsScheme) {
                treeSet.add((FsScheme)object);
            } else {
                for (String string : new SuffixSet(object.toString())) {
                    treeSet.add(new FsScheme(string));
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        return treeSet;
    }
}

