/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;

@ThreadSafe
public class LockInputStream
extends DecoratingInputStream {
    protected final Lock lock;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockInputStream(@Nullable @WillCloseWhenClosed InputStream inputStream, Lock lock) {
        super(inputStream);
        this.lock = lock;
        if (null == this.lock) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read() throws IOException {
        this.lock.lock();
        try {
            int n2 = this.delegate.read();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.lock.lock();
        try {
            int n4 = this.delegate.read(byArray, n2, n3);
            return n4;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public long skip(long l2) throws IOException {
        this.lock.lock();
        try {
            long l3 = this.delegate.skip(l2);
            return l3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int available() throws IOException {
        this.lock.lock();
        try {
            int n2 = this.delegate.available();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.delegate.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void mark(int n2) {
        this.lock.lock();
        try {
            this.delegate.mark(n2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void reset() throws IOException {
        this.lock.lock();
        try {
            this.delegate.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public boolean markSupported() {
        this.lock.lock();
        try {
            boolean bl2 = this.delegate.markSupported();
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

