/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.util.ThreadGroups;
import zz.de.schlichtherle.truezip.util.Throwables;

@Immutable
public class Streams {
    static final int FIFO_SIZE = 4;
    public static final int BUFFER_SIZE = 8192;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ReaderThreadFactory());

    private Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@WillClose InputStream inputStream, @WillClose OutputStream outputStream) throws IOException {
        try {
            Streams.cat(inputStream, outputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new InputException(iOException);
            }
            finally {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void cat(final @WillNotClose InputStream var0, @WillNotClose OutputStream var1_1) throws IOException {
        if (null == var0 || null == var1_1) {
            throw new NullPointerException();
        }
        var2_2 = new ReentrantLock();
        var3_3 = var2_2.newCondition();
        var4_4 = Buffer.allocate();
        var5_5 = false;
        try {
            var6_6 = new ReaderTask();
            var7_7 = Streams.executor.submit(var6_6);
            var8_8 = var4_4.length;
            while (true) lbl-1000:
            // 3 sources

            {
                var2_2.lock();
                try {
                    while (0 >= var6_6.size) {
                        try {
                            var3_3.await();
                        }
                        catch (InterruptedException var9_10) {
                            var5_5 = true;
                        }
                    }
                    var10_14 = var6_6.off;
                    var11_16 = var4_4[var10_14];
                }
                finally {
                    var2_2.unlock();
                }
                var13_17 = var11_16.read;
                if (var13_17 == -1) ** break;
                try {
                    var9_9 = var11_16.buf;
                    var1_1.write(var9_9, 0, var13_17);
                }
                catch (IOException var9_11) {
                    Streams.cancel(var7_7);
                    throw var9_11;
                }
                catch (RuntimeException var9_12) {
                    Streams.cancel(var7_7);
                    throw var9_12;
                }
                catch (Error var9_13) {
                    Streams.cancel(var7_7);
                    throw var9_13;
                }
                var2_2.lock();
                try {
                    var6_6.off = (var10_14 + 1) % var8_8;
                    --var6_6.size;
                    var3_3.signal();
                }
                finally {
                    var2_2.unlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            var1_1.flush();
            var10_15 = var6_6.exception;
            if (null != var10_15) {
                if (var10_15 instanceof InputException) {
                    throw (InputException)var10_15;
                }
                if (var10_15 instanceof IOException) {
                    throw new InputException((IOException)var10_15);
                }
                if (var10_15 instanceof RuntimeException) {
                    throw (RuntimeException)Throwables.wrap(var10_15);
                }
                throw (Error)Throwables.wrap(var10_15);
            }
        }
        finally {
            if (var5_5) {
                Thread.currentThread().interrupt();
            }
            Buffer.release(var4_4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancel(Future<?> future) {
        future.cancel(true);
        boolean bl2 = false;
        try {
            while (true) {
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                    throw new AssertionError((Object)executionException);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final class ReaderThread
    extends Thread {
        ReaderThread(Runnable runnable) {
            super(ThreadGroups.getServerThreadGroup(), runnable, ReaderThread.class.getName());
            this.setDaemon(true);
        }
    }

    private static final class ReaderThreadFactory
    implements ThreadFactory {
        private ReaderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new ReaderThread(runnable);
        }
    }

    private static final class Buffer {
        static final Queue<Reference<Buffer[]>> queue = new ConcurrentLinkedQueue<Reference<Buffer[]>>();
        final byte[] buf = new byte[8192];
        int read;

        private Buffer() {
        }

        static Buffer[] allocate() {
            Buffer[] bufferArray;
            while (null != (bufferArray = queue.poll())) {
                Buffer[] bufferArray2 = bufferArray.get();
                if (null == bufferArray2) continue;
                return bufferArray2;
            }
            bufferArray = new Buffer[4];
            int n2 = bufferArray.length;
            while (0 <= --n2) {
                bufferArray[n2] = new Buffer();
            }
            return bufferArray;
        }

        static void release(Buffer[] bufferArray) {
            queue.add(new SoftReference<Buffer[]>(bufferArray));
        }
    }
}

