/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key;

import java.io.Closeable;
import java.net.URI;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.key.CacheableUnknownKeyException;
import zz.de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import zz.de.schlichtherle.truezip.key.PromptingKeyManager;
import zz.de.schlichtherle.truezip.key.SafeKey;
import zz.de.schlichtherle.truezip.key.SafeKeyProvider;
import zz.de.schlichtherle.truezip.key.UnknownKeyException;

@ThreadSafe
public final class PromptingKeyProvider<K extends SafeKey<K>>
extends SafeKeyProvider<K> {
    private final View<K> view;
    private volatile State state = State.RESET;
    @CheckForNull
    private volatile URI resource;
    private volatile boolean changeRequested;
    @CheckForNull
    private volatile CacheableUnknownKeyException exception;

    PromptingKeyProvider(PromptingKeyManager<K> promptingKeyManager) {
        this.view = promptingKeyManager.getView();
    }

    private View<K> getView() {
        return this.view;
    }

    private State getState() {
        return this.state;
    }

    private void setState(State state) {
        assert (null != state);
        this.state = state;
    }

    @CheckForNull
    public URI getResource() {
        return this.resource;
    }

    void setResource(@CheckForNull URI uRI) {
        this.resource = uRI;
    }

    @Override
    protected void retrieveWriteKey() throws UnknownKeyException {
        this.getState().retrieveWriteKey(this);
    }

    @Override
    protected void retrieveReadKey(boolean bl2) throws UnknownKeyException {
        this.getState().retrieveReadKey(this, bl2);
    }

    @Override
    protected K getKey() {
        return this.getState().getKey(this);
    }

    @CheckForNull
    private K getKey0() {
        return super.getKey();
    }

    @Override
    public void setKey(@CheckForNull K k2) {
        this.getState().setKey(this, k2);
    }

    private void setKey0(@CheckForNull K k2) {
        super.setKey(k2);
    }

    private boolean isChangeRequested() {
        return this.changeRequested;
    }

    private void setChangeRequested(boolean bl2) {
        this.changeRequested = bl2;
    }

    @CheckForNull
    private CacheableUnknownKeyException getException() {
        return this.exception;
    }

    private void setException(@CheckForNull CacheableUnknownKeyException cacheableUnknownKeyException) {
        this.exception = cacheableUnknownKeyException;
    }

    public void resetCancelledKey() {
        this.getState().resetCancelledKey(this);
    }

    public void resetUnconditionally() {
        this.reset();
    }

    private void reset() {
        this.setKey0(null);
        this.setChangeRequested(false);
        this.setException(null);
        this.setState(State.RESET);
    }

    @NotThreadSafe
    private final class ReadController
    extends BaseController {
        ReadController(State state) {
            super(state);
        }

        @Override
        public K getKey() {
            throw new IllegalStateException();
        }
    }

    @NotThreadSafe
    private final class WriteController
    extends BaseController {
        WriteController(State state) {
            super(state);
        }

        @Override
        public void setChangeRequested(boolean bl2) {
            throw new IllegalStateException();
        }
    }

    @NotThreadSafe
    private abstract class BaseController
    implements Closeable,
    Controller<K> {
        @CheckForNull
        private State state;

        BaseController(State state) {
            this.state = state;
        }

        private State getState() {
            State state = this.state;
            if (null == state) {
                throw new IllegalStateException();
            }
            return state;
        }

        @Override
        public void close() {
            this.state = null;
        }

        @Override
        public URI getResource() {
            URI uRI = this.getState().getResource(PromptingKeyProvider.this);
            if (null == uRI) {
                throw new IllegalStateException();
            }
            return uRI;
        }

        @Override
        public K getKey() {
            return this.getState().getKey(PromptingKeyProvider.this);
        }

        @Override
        public void setKey(K k2) {
            this.getState().setKey(PromptingKeyProvider.this, k2);
        }

        @Override
        public void setChangeRequested(boolean bl2) {
            this.getState().setChangeRequested(PromptingKeyProvider.this, bl2);
        }
    }

    @NotThreadSafe
    public static interface Controller<K extends SafeKey<K>> {
        public URI getResource();

        @CheckForNull
        public K getKey();

        public void setKey(@CheckForNull K var1);

        public void setChangeRequested(boolean var1);
    }

    public static interface View<K extends SafeKey<K>> {
        public void promptWriteKey(Controller<K> var1) throws UnknownKeyException;

        public void promptReadKey(Controller<K> var1, boolean var2) throws UnknownKeyException;
    }

    @ThreadSafe
    private static enum State {
        RESET{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> promptingKeyProvider) throws UnknownKeyException {
                State state;
                try {
                    PromptingKeyProvider<K> promptingKeyProvider2 = promptingKeyProvider;
                    promptingKeyProvider2.getClass();
                    WriteController writeController = promptingKeyProvider2.new WriteController(this);
                    try {
                        ((PromptingKeyProvider)promptingKeyProvider).getView().promptWriteKey(writeController);
                    }
                    finally {
                        writeController.close();
                    }
                }
                finally {
                    state = ((PromptingKeyProvider)promptingKeyProvider).getState();
                    if (this == state) {
                        state = CANCELLED;
                        ((PromptingKeyProvider)promptingKeyProvider).setState(state);
                    }
                }
                state.retrieveWriteKey(promptingKeyProvider);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> promptingKeyProvider, boolean bl2) throws UnknownKeyException {
                State state;
                do {
                    try {
                        PromptingKeyProvider<K> promptingKeyProvider2 = promptingKeyProvider;
                        promptingKeyProvider2.getClass();
                        ReadController readController = promptingKeyProvider2.new ReadController(this);
                        try {
                            ((PromptingKeyProvider)promptingKeyProvider).getView().promptReadKey(readController, bl2);
                        }
                        finally {
                            readController.close();
                        }
                    }
                    catch (CacheableUnknownKeyException cacheableUnknownKeyException) {
                        this.setException(promptingKeyProvider, cacheableUnknownKeyException);
                    }
                } while ((state = ((PromptingKeyProvider)promptingKeyProvider).getState()) == this);
                state.retrieveReadKey(promptingKeyProvider, false);
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> promptingKeyProvider) {
            }
        }
        ,
        SET{

            @Override
            <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> promptingKeyProvider) throws UnknownKeyException {
                if (((PromptingKeyProvider)promptingKeyProvider).isChangeRequested()) {
                    ((PromptingKeyProvider)promptingKeyProvider).setChangeRequested(false);
                    RESET.retrieveWriteKey(promptingKeyProvider);
                }
            }

            @Override
            <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> promptingKeyProvider, boolean bl2) throws UnknownKeyException {
                if (bl2) {
                    ((PromptingKeyProvider)promptingKeyProvider).setState(2.RESET);
                    RESET.retrieveReadKey(promptingKeyProvider, true);
                }
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> promptingKeyProvider) {
            }
        }
        ,
        CANCELLED{

            @Override
            <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> promptingKeyProvider) throws UnknownKeyException {
                throw this.getException(promptingKeyProvider);
            }

            @Override
            <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> promptingKeyProvider, boolean bl2) throws UnknownKeyException {
                throw this.getException(promptingKeyProvider);
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> promptingKeyProvider) {
                ((PromptingKeyProvider)promptingKeyProvider).reset();
            }
        };


        abstract <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> var1) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> var1, boolean var2) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> var1);

        @CheckForNull
        final <K extends SafeKey<K>> K getKey(PromptingKeyProvider<K> promptingKeyProvider) {
            return (K)((PromptingKeyProvider)promptingKeyProvider).getKey0();
        }

        final <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> promptingKeyProvider, @CheckForNull K k2) {
            ((PromptingKeyProvider)promptingKeyProvider).setKey0(k2);
            ((PromptingKeyProvider)promptingKeyProvider).setState(null != k2 ? State.SET : State.CANCELLED);
        }

        <K extends SafeKey<K>> void setChangeRequested(PromptingKeyProvider<K> promptingKeyProvider, boolean bl2) {
            ((PromptingKeyProvider)promptingKeyProvider).setChangeRequested(bl2);
        }

        @CheckForNull
        <K extends SafeKey<K>> URI getResource(PromptingKeyProvider<K> promptingKeyProvider) {
            return promptingKeyProvider.getResource();
        }

        final <K extends SafeKey<K>> CacheableUnknownKeyException getException(PromptingKeyProvider<K> promptingKeyProvider) {
            CacheableUnknownKeyException cacheableUnknownKeyException = ((PromptingKeyProvider)promptingKeyProvider).getException();
            if (null == cacheableUnknownKeyException) {
                cacheableUnknownKeyException = new KeyPromptingCancelledException();
                ((PromptingKeyProvider)promptingKeyProvider).setException(cacheableUnknownKeyException);
            }
            return cacheableUnknownKeyException;
        }

        final <K extends SafeKey<K>> void setException(PromptingKeyProvider<K> promptingKeyProvider, CacheableUnknownKeyException cacheableUnknownKeyException) {
            ((PromptingKeyProvider)promptingKeyProvider).setException(cacheableUnknownKeyException);
            ((PromptingKeyProvider)promptingKeyProvider).setState(State.CANCELLED);
        }
    }
}

