/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key.pbe;

import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.param.KeyStrength;
import zz.de.schlichtherle.truezip.key.SafeKey;

@NotThreadSafe
public abstract class SafePbeParameters<S extends KeyStrength, P extends SafePbeParameters<S, P>>
implements SafeKey<P> {
    @CheckForNull
    private char[] password;
    @CheckForNull
    private S keyStrength;

    @Override
    public P clone() {
        SafePbeParameters safePbeParameters;
        try {
            safePbeParameters = (SafePbeParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        char[] cArray = this.password;
        if (null != cArray) {
            safePbeParameters.password = (char[])cArray.clone();
        }
        return (P)safePbeParameters;
    }

    @Override
    public void reset() {
        this.setPassword(null);
        this.setKeyStrength(null);
    }

    @Nullable
    public char[] getPassword() {
        return null == this.password ? null : (char[])this.password.clone();
    }

    public void setPassword(@CheckForNull char[] cArray) {
        char[] cArray2 = this.password;
        if (null != cArray2) {
            Arrays.fill(cArray2, '\u0000');
        }
        this.password = null == cArray ? null : (char[])cArray.clone();
    }

    public void setKeyFileBytes(@CheckForNull byte[] byArray) {
        char[] cArray = this.password;
        if (null != cArray) {
            Arrays.fill(cArray, '\u0000');
        }
        if (null != byArray) {
            int n2 = byArray.length;
            char[] cArray2 = new char[n2 >>= 1];
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                cArray2[i2] = (char)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
            }
            this.password = cArray2;
        } else {
            this.password = null;
        }
    }

    public abstract S[] getKeyStrengthValues();

    @Nullable
    public S getKeyStrength() {
        return this.keyStrength;
    }

    public void setKeyStrength(@CheckForNull S s2) {
        this.keyStrength = s2;
    }
}

