/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key.pbe.console;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Console;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.crypto.param.KeyStrength;
import zz.de.schlichtherle.truezip.key.KeyPromptingDisabledException;
import zz.de.schlichtherle.truezip.key.PromptingKeyProvider;
import zz.de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import zz.de.schlichtherle.truezip.key.pbe.SafePbeParametersView;

@ThreadSafe
public abstract class ConsoleSafePbeParametersView<S extends KeyStrength, P extends SafePbeParameters<S, P>>
extends SafePbeParametersView<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(ConsoleSafePbeParametersView.class.getName());
    private static final PromptingLock lock = new PromptingLock();
    private static final int MIN_PASSWD_LEN = 8;
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private static URI lastResource = URI.create("");
    private static final String YES = resources.getString("yes");
    private static final String NO = resources.getString("no");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void promptWriteKey(PromptingKeyProvider.Controller<P> controller) throws KeyPromptingDisabledException {
        Console console = System.console();
        if (null == console) {
            throw new KeyPromptingDisabledException();
        }
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            Object object;
            Object object2;
            URI uRI = controller.getResource();
            assert (null != uRI);
            if (!lastResource.equals(uRI)) {
                console.printf(resources.getString("writeKey.banner"), uRI);
            }
            lastResource = uRI;
            SafePbeParameters safePbeParameters = (SafePbeParameters)controller.getKey();
            if (null == safePbeParameters) {
                safePbeParameters = this.newPbeParameters();
            }
            while (true) {
                if (null == (object2 = console.readPassword(resources.getString("writeKey.newPasswd1"), new Object[0])) || 0 >= ((char[])object2).length) {
                    return;
                }
                if (8 > ((char[])object2).length) {
                    console.printf(resources.getString("writeKey.passwd.tooShort"), 8);
                    continue;
                }
                try {
                    block26: {
                        object = console.readPassword(resources.getString("writeKey.newPasswd2"), new Object[0]);
                        if (object == null) {
                            return;
                        }
                        try {
                            if (Arrays.equals(object2, (char[])object)) break block26;
                            console.printf(resources.getString("writeKey.passwd.noMatch"), new Object[0]);
                        }
                        catch (Throwable throwable) {
                            Arrays.fill((char[])object, '\u0000');
                            throw throwable;
                        }
                        Arrays.fill((char[])object, '\u0000');
                        continue;
                    }
                    safePbeParameters.setPassword((char[])object2);
                    Arrays.fill((char[])object, '\u0000');
                }
                finally {
                    Arrays.fill(object2, '\u0000');
                    continue;
                }
                break;
            }
            console.printf(resources.getString("keyStrength.banner"), new Object[0]);
            CharSequence charSequence = new StringBuilder();
            KeyStrength[] keyStrengthArray = safePbeParameters.getKeyStrengthValues();
            object = new HashMap(keyStrengthArray.length / 3 * 4 + 1);
            Object object3 = console.writer();
            for (KeyStrength keyStrength : keyStrengthArray) {
                if (0 < ((StringBuilder)charSequence).length()) {
                    ((StringBuilder)charSequence).append('/');
                }
                ((StringBuilder)charSequence).append(keyStrength.getBits());
                object.put(keyStrength.getBits(), keyStrength);
                ((PrintWriter)object3).println(keyStrength);
            }
            object2 = ((StringBuilder)charSequence).toString();
            while (null != (charSequence = console.readLine(resources.getString("keyStrength.prompt"), object2, safePbeParameters.getKeyStrength().getBits())) && ((String)charSequence).length() > 0) {
                try {
                    int n2 = Integer.parseInt((String)charSequence);
                    object3 = (KeyStrength)object.get(n2);
                    if (null == object3) continue;
                    assert (object3.getBits() == n2);
                    safePbeParameters.setKeyStrength(object3);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            controller.setKey(safePbeParameters);
        }
    }

    @Override
    public void promptReadKey(PromptingKeyProvider.Controller<P> controller, boolean bl2) throws KeyPromptingDisabledException {
        Console console = System.console();
        if (null == console) {
            throw new KeyPromptingDisabledException();
        }
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            String string;
            if (bl2) {
                console.printf(resources.getString("readKey.invalid"), new Object[0]);
            }
            URI uRI = controller.getResource();
            assert (null != uRI);
            if (!lastResource.equals(uRI)) {
                console.printf(resources.getString("readKey.banner"), uRI);
            }
            lastResource = uRI;
            char[] cArray = console.readPassword(resources.getString("readKey.passwd"), new Object[0]);
            if (null == cArray || cArray.length <= 0) {
                controller.setKey(null);
                return;
            }
            Object p2 = this.newPbeParameters();
            ((SafePbeParameters)p2).setPassword(cArray);
            Arrays.fill(cArray, '\u0000');
            controller.setKey(p2);
            do {
                string = console.readLine(resources.getString("readKey.change"), new Object[0]);
                controller.setChangeRequested(YES.equalsIgnoreCase(string));
            } while (null != string && string.length() > 0 && !YES.equalsIgnoreCase(string) && !NO.equalsIgnoreCase(string));
            return;
        }
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }
}

