/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key.pbe.swing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import zz.de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import zz.de.schlichtherle.truezip.key.pbe.swing.AuthenticationPanel;
import zz.de.schlichtherle.truezip.key.pbe.swing.KeyPanel;
import zz.de.schlichtherle.truezip.key.pbe.swing.SwingSafePbeParametersView;
import zz.de.schlichtherle.truezip.swing.EnhancedPanel;
import zz.de.schlichtherle.truezip.swing.PanelEvent;
import zz.de.schlichtherle.truezip.swing.PanelListener;

public class ReadKeyPanel
extends KeyPanel {
    private static final long serialVersionUID = 984673974236493651L;
    private static final String CLASS_NAME = ReadKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private final Color defaultForeground;
    AuthenticationPanel authenticationPanel;
    private final JCheckBox changeKey = new JCheckBox();
    JLabel error;
    JPasswordField passwdField;
    JLabel passwdLabel;
    EnhancedPanel passwdPanel;
    JTextPane resource;

    public ReadKeyPanel() {
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ReadKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ReadKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ReadKeyPanel.this.setError(null);
            }
        };
        this.passwdField.getDocument().addDocumentListener(documentListener);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(documentListener);
        this.defaultForeground = this.resource.getForeground();
    }

    @Override
    public URI getResource() {
        return URI.create(this.resource.getText());
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setResource(URI uRI) {
        URI uRI2 = SwingSafePbeParametersView.lastResource;
        if (!uRI2.equals(uRI) && !uRI2.equals(SwingSafePbeParametersView.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(uRI.toString());
        SwingSafePbeParametersView.lastResource = uRI;
    }

    @Override
    public String getError() {
        String string = this.error.getText();
        return string.isEmpty() ? null : string;
    }

    @Override
    public void setError(String string) {
        this.error.setText(string);
    }

    @Override
    boolean updateParam(SafePbeParameters<?, ?> safePbeParameters) {
        switch (this.authenticationPanel.getAuthenticationMethod()) {
            case 0: {
                char[] cArray = this.passwdField.getPassword();
                safePbeParameters.setPassword(cArray);
                Arrays.fill(cArray, '\u0000');
                return true;
            }
            case 1: {
                File file = this.authenticationPanel.getKeyFile();
                try {
                    byte[] byArray = SwingSafePbeParametersView.readKeyFile(file);
                    safePbeParameters.setKeyFileBytes(byArray);
                    Arrays.fill(byArray, (byte)0);
                    return true;
                }
                catch (EOFException eOFException) {
                    this.setError(resources.getString("keyFile.eofException"));
                    return false;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.setError(resources.getString("keyFile.fileNotFoundException"));
                    return false;
                }
                catch (IOException iOException) {
                    this.setError(resources.getString("keyFile.ioException"));
                    return false;
                }
            }
        }
        throw new AssertionError((Object)"Unsupported authentication method!");
    }

    public boolean isChangeKeySelected() {
        return this.changeKey.isSelected();
    }

    public void setChangeKeySelected(boolean bl2) {
        this.changeKey.setSelected(bl2);
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.passwdLabel = new JLabel();
        this.passwdField = new JPasswordField();
        JLabel jLabel = new JLabel();
        this.resource = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                ReadKeyPanel.this.passwdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.passwdPanel.setLayout((LayoutManager)new GridBagLayout());
        this.passwdLabel.setDisplayedMnemonic(resources.getString("passwd").charAt(0));
        this.passwdLabel.setLabelFor(this.passwdField);
        this.passwdLabel.setText(resources.getString("passwd"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.passwdLabel, (Object)gridBagConstraints);
        this.passwdField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.passwdField, (Object)gridBagConstraints);
        this.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.resource);
        jLabel.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(jLabel, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.resource.getFont().deriveFont(this.resource.getFont().getStyle() | 1));
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel((JPanel)this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.authenticationPanel, gridBagConstraints);
        this.changeKey.setText(resources.getString("changeKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.changeKey, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent panelEvent) {
        final Window window = panelEvent.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ReadKeyPanel.this.passwdField.requestFocusInWindow()) {
                            ReadKeyPanel.this.passwdField.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }
}

