/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key.pbe.swing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.annotation.CheckForNull;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import zz.de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import zz.de.schlichtherle.truezip.key.pbe.swing.AuthenticationPanel;
import zz.de.schlichtherle.truezip.key.pbe.swing.KeyPanel;
import zz.de.schlichtherle.truezip.key.pbe.swing.SwingSafePbeParametersView;
import zz.de.schlichtherle.truezip.key.pbe.swing.WeakKeyException;
import zz.de.schlichtherle.truezip.swing.EnhancedPanel;
import zz.de.schlichtherle.truezip.swing.PanelEvent;
import zz.de.schlichtherle.truezip.swing.PanelListener;

public class WriteKeyPanel
extends KeyPanel {
    private static final long serialVersionUID = 6416529465492387235L;
    private static final String CLASS_NAME = WriteKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final int MIN_PASSWD_LEN = 8;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private AuthenticationPanel authenticationPanel;
    private JLabel error;
    private JPasswordField newPasswd1Field;
    private JLabel newPasswd1Label;
    private JPasswordField newPasswd2Field;
    private JLabel newPasswd2Label;
    private EnhancedPanel passwdPanel;
    private JTextPane resource;

    public WriteKeyPanel() {
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                WriteKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                WriteKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                WriteKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1Field.getDocument().addDocumentListener(documentListener);
        this.newPasswd2Field.getDocument().addDocumentListener(documentListener);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(documentListener);
        this.defaultForeground = this.resource.getForeground();
    }

    @Override
    public URI getResource() {
        return URI.create(this.resource.getText());
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setResource(URI uRI) {
        URI uRI2 = SwingSafePbeParametersView.lastResource;
        if (!uRI2.equals(uRI) && !uRI2.equals(SwingSafePbeParametersView.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(uRI.toString());
        SwingSafePbeParametersView.lastResource = uRI;
    }

    @Override
    public String getError() {
        String string = this.error.getText();
        return string.trim().length() > 0 ? string : null;
    }

    @Override
    public void setError(String string) {
        this.error.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    boolean updateParam(SafePbeParameters<?, ?> safePbeParameters) {
        try {
            switch (this.authenticationPanel.getAuthenticationMethod()) {
                case 0: {
                    char[] cArray = this.newPasswd1Field.getPassword();
                    char[] cArray2 = this.newPasswd2Field.getPassword();
                    try {
                        if (Arrays.equals(cArray, cArray2)) {
                            this.checkPasswdKey(cArray);
                            this.setError(null);
                            safePbeParameters.setPassword(cArray);
                            boolean bl2 = true;
                            return bl2;
                        }
                        this.setError(resources.getString("passwd.noMatch"));
                        boolean bl3 = false;
                        return bl3;
                    }
                    finally {
                        Arrays.fill(cArray, '\u0000');
                        Arrays.fill(cArray2, '\u0000');
                    }
                }
                case 1: {
                    byte[] byArray;
                    File file = this.authenticationPanel.getKeyFile();
                    if (file.canWrite()) {
                        this.setError(resources.getString("keyFile.canWrite"));
                        return false;
                    }
                    try {
                        byArray = SwingSafePbeParametersView.readKeyFile(file);
                    }
                    catch (EOFException eOFException) {
                        this.setError(resources.getString("keyFile.eofException"));
                        return false;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.setError(resources.getString("keyFile.fileNotFoundException"));
                        return false;
                    }
                    catch (IOException iOException) {
                        this.setError(resources.getString("keyFile.ioException"));
                        return false;
                    }
                    this.checkKeyFileKey(byArray);
                    this.setError(null);
                    safePbeParameters.setKeyFileBytes(byArray);
                    Arrays.fill(byArray, (byte)0);
                    return true;
                }
            }
            throw new AssertionError((Object)"Unsupported authentication method!");
        }
        catch (WeakKeyException weakKeyException) {
            this.setError(weakKeyException.getLocalizedMessage());
            return false;
        }
    }

    protected void checkKeyFileKey(byte[] byArray) throws WeakKeyException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        assert (deflater.getTotalOut() == 0);
        int n2 = deflater.deflate(new byte[byArray.length * 2]);
        assert (deflater.getTotalOut() == n2);
        deflater.end();
        if (n2 < 64) {
            throw new WeakKeyException(WriteKeyPanel.localizedMessage(resources, "keyFile.badEntropy", null));
        }
    }

    protected void checkPasswdKey(char[] cArray) throws WeakKeyException {
        if (8 > cArray.length) {
            throw new WeakKeyException(WriteKeyPanel.localizedMessage(resources, "passwd.tooShort", 8));
        }
    }

    private static String localizedMessage(ResourceBundle resourceBundle, String string, @CheckForNull Object object) {
        return object != null ? MessageFormat.format(resourceBundle.getString(string), object) : resourceBundle.getString(string);
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent jComponent) {
        if (this.extraDataUI == jComponent) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (jComponent != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add(jComponent, gridBagConstraints);
        }
        this.extraDataUI = jComponent;
        this.revalidate();
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.newPasswd1Label = new JLabel();
        this.newPasswd1Field = new JPasswordField();
        this.newPasswd2Label = new JLabel();
        this.newPasswd2Field = new JPasswordField();
        JLabel jLabel = new JLabel();
        this.resource = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                WriteKeyPanel.this.passwdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.passwdPanel.setLayout((LayoutManager)new GridBagLayout());
        this.newPasswd1Label.setDisplayedMnemonic(resources.getString("newPasswd1").charAt(0));
        this.newPasswd1Label.setLabelFor(this.newPasswd1Field);
        this.newPasswd1Label.setText(resources.getString("newPasswd1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.passwdPanel.add((Component)this.newPasswd1Label, (Object)gridBagConstraints);
        this.newPasswd1Field.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.passwdPanel.add((Component)this.newPasswd1Field, (Object)gridBagConstraints);
        this.newPasswd2Label.setDisplayedMnemonic(resources.getString("newPasswd2").charAt(0));
        this.newPasswd2Label.setLabelFor(this.newPasswd2Field);
        this.newPasswd2Label.setText(resources.getString("newPasswd2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.newPasswd2Label, (Object)gridBagConstraints);
        this.newPasswd2Field.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.newPasswd2Field, (Object)gridBagConstraints);
        this.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.resource);
        jLabel.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(jLabel, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.resource.getFont().deriveFont(this.resource.getFont().getStyle() | 1));
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel((JPanel)this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.authenticationPanel, gridBagConstraints);
        this.error.setForeground(new Color(255, 0, 0));
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent panelEvent) {
        final Window window = panelEvent.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WriteKeyPanel.this.newPasswd1Field.requestFocusInWindow()) {
                            WriteKeyPanel.this.newPasswd1Field.selectAll();
                            WriteKeyPanel.this.newPasswd2Field.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }
}

