/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.rof;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.rof.AbstractReadOnlyFile;

@NotThreadSafe
public class ByteArrayReadOnlyFile
extends AbstractReadOnlyFile {
    private final byte[] buffer;
    private final int start;
    private int position;
    private int limit;

    @CreatesObligation
    public ByteArrayReadOnlyFile(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayReadOnlyFile(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.position = this.start = n2;
        this.limit = Math.min(n2 + n3, byArray.length);
    }

    @Override
    public long length() {
        return this.limit - this.start;
    }

    @Override
    public long getFilePointer() {
        return this.position - this.start;
    }

    @Override
    public void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException();
        }
        this.position = (l2 += (long)this.start) < (long)this.limit ? (int)l2 : this.limit;
    }

    @Override
    public int read() {
        return this.position < this.limit ? this.buffer[this.position++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return 0;
        }
        int n4 = this.position;
        int n5 = this.limit - n4;
        if (n5 <= 0) {
            return -1;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        System.arraycopy(this.buffer, n4, byArray, n2, n3);
        this.position += n3;
        return n3;
    }

    @Override
    public void close() throws IOException {
    }
}

