/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.rof;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;

@ThreadSafe
public class LockReadOnlyFile
extends DecoratingReadOnlyFile {
    protected final Lock lock;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockReadOnlyFile(@Nullable @WillCloseWhenClosed ReadOnlyFile readOnlyFile, Lock lock) {
        super(readOnlyFile);
        this.lock = lock;
        if (null == this.lock) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws IOException {
        this.lock.lock();
        try {
            long l2 = this.delegate.length();
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePointer() throws IOException {
        this.lock.lock();
        try {
            long l2 = this.delegate.getFilePointer();
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long l2) throws IOException {
        this.lock.lock();
        try {
            this.delegate.seek(l2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        this.lock.lock();
        try {
            int n2 = this.delegate.read();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.lock.lock();
        try {
            int n4 = this.delegate.read(byArray, n2, n3);
            return n4;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.lock.lock();
        try {
            this.delegate.readFully(byArray, n2, n3);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.delegate.close();
        }
        finally {
            this.lock.unlock();
        }
    }
}

