/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.rof;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;

@CleanupObligation
@NotThreadSafe
public class ReadOnlyFileInputStream
extends InputStream {
    @Nullable
    protected ReadOnlyFile rof;
    private long mark = -1L;

    @CreatesObligation
    public ReadOnlyFileInputStream(@Nullable @WillCloseWhenClosed ReadOnlyFile readOnlyFile) {
        this.rof = readOnlyFile;
    }

    @Override
    public int read() throws IOException {
        return this.rof.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.rof.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.rof.read(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) throws IOException {
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = this.rof.getFilePointer();
        long l4 = this.rof.length();
        long l5 = l4 - l3;
        if (l2 > l5) {
            l2 = (int)l5;
        }
        this.rof.seek(l3 + l2);
        return l2;
    }

    @Override
    public int available() throws IOException {
        long l2 = this.rof.length() - this.rof.getFilePointer();
        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.rof.close();
    }

    @Override
    public void mark(int n2) {
        try {
            this.mark = this.rof.getFilePointer();
        }
        catch (IOException iOException) {
            Logger.getLogger(ReadOnlyFileInputStream.class.getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            this.mark = -2L;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException(this.mark == -1L ? "no mark set" : "mark()/reset() not supported by underlying file");
        }
        this.rof.seek(this.mark);
    }

    @Override
    public boolean markSupported() {
        try {
            this.rof.seek(this.rof.getFilePointer());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

