/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.socket;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.io.DisconnectingOutputStream;
import zz.de.schlichtherle.truezip.io.OutputClosedException;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputShop;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.JSE7;

@NotThreadSafe
public class DisconnectingOutputShop<E extends Entry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private boolean closed;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public DisconnectingOutputShop(@WillCloseWhenClosed OutputShop<E> outputShop) {
        super(outputShop);
    }

    public boolean isClosed() {
        return this.closed;
    }

    final void assertOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException(new OutputClosedException());
        }
    }

    final void checkOpen() throws IOException {
        if (this.isClosed()) {
            throw new OutputClosedException();
        }
    }

    @Override
    public int getSize() {
        this.assertOpen();
        return ((OutputShop)this.delegate).getSize();
    }

    @Override
    public Iterator<E> iterator() {
        this.assertOpen();
        return ((OutputShop)this.delegate).iterator();
    }

    @Override
    public E getEntry(String string) {
        this.assertOpen();
        return ((OutputShop)this.delegate).getEntry(string);
    }

    @Override
    public final OutputSocket<? extends E> getOutputSocket(E e2) {
        return SOCKET_FACTORY.newOutputSocket(this, ((OutputShop)this.delegate).getOutputSocket(e2));
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ((OutputShop)this.delegate).close();
    }

    private final class DisconnectingOutputStreamImpl
    extends DisconnectingOutputStream {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingOutputStreamImpl(@WillCloseWhenClosed OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public boolean isOpen() {
            return !DisconnectingOutputShop.this.isClosed();
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.isOpen()) {
                this.delegate.close();
            }
        }
    }

    private final class DisconnectingSeekableByteChannel
    extends zz.de.schlichtherle.truezip.io.DisconnectingSeekableByteChannel {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingSeekableByteChannel(@WillCloseWhenClosed SeekableByteChannel seekableByteChannel) {
            super(seekableByteChannel);
        }

        @Override
        public boolean isOpen() {
            return !DisconnectingOutputShop.this.isClosed();
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.isOpen()) {
                this.delegate.close();
            }
        }
    }

    private class Output
    extends DecoratingOutputSocket<E> {
        Output(OutputSocket<? extends E> outputSocket) {
            super(outputSocket);
        }

        @Override
        protected OutputSocket<? extends E> getBoundSocket() throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            return this.getDelegate().bind(this);
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return new DisconnectingOutputStreamImpl(this.getBoundSocket().newOutputStream());
        }
    }

    private class Nio2Output
    extends Output {
        Nio2Output(OutputSocket<? extends E> outputSocket) {
            super(outputSocket);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new DisconnectingSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            <E extends Entry> OutputSocket<? extends E> newOutputSocket(DisconnectingOutputShop<E> disconnectingOutputShop, OutputSocket<? extends E> outputSocket) {
                DisconnectingOutputShop<E> disconnectingOutputShop2 = disconnectingOutputShop;
                disconnectingOutputShop2.getClass();
                return disconnectingOutputShop2.new Nio2Output(outputSocket);
            }
        }
        ,
        OIO{

            @Override
            <E extends Entry> OutputSocket<? extends E> newOutputSocket(DisconnectingOutputShop<E> disconnectingOutputShop, OutputSocket<? extends E> outputSocket) {
                DisconnectingOutputShop<E> disconnectingOutputShop2 = disconnectingOutputShop;
                disconnectingOutputShop2.getClass();
                return disconnectingOutputShop2.new Output(outputSocket);
            }
        };


        abstract <E extends Entry> OutputSocket<? extends E> newOutputSocket(DisconnectingOutputShop<E> var1, OutputSocket<? extends E> var2);
    }
}

