/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.Streams;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;

@ThreadSafe
public abstract class IOSocket<LT, PT> {
    IOSocket() {
    }

    public abstract LT getLocalTarget() throws IOException;

    @CheckForNull
    public abstract PT getPeerTarget() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputSocket<?> inputSocket, OutputSocket<?> outputSocket) throws IOException {
        InputStream inputStream;
        if (null == outputSocket) {
            throw new NullPointerException();
        }
        OutputStream outputStream = null;
        try {
            inputStream = inputSocket.connect(outputSocket).newInputStream();
        }
        catch (IOException iOException) {
            throw new InputException(iOException);
        }
        try {
            outputStream = outputSocket.newOutputStream();
        }
        finally {
            if (null == outputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new InputException(iOException);
                }
            }
        }
        Streams.copy(inputStream, outputStream);
        inputSocket.connect(null);
    }

    public String toString() {
        Object object;
        Object object2;
        try {
            object2 = this.getLocalTarget();
        }
        catch (IOException iOException) {
            object2 = iOException;
        }
        try {
            object = this.getPeerTarget();
        }
        catch (IOException iOException) {
            object = iOException;
        }
        return String.format("%s[localTarget=%s, peerTarget=%s]", this.getClass().getName(), object2, object);
    }

    public final boolean equals(@CheckForNull Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

