/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InheritableThreadLocalStack<T> {
    private final InheritableThreadLocal<Node<T>> nodes = new InheritableThreadLocal();

    public boolean isEmpty() {
        return null == this.nodes.get();
    }

    @Nullable
    public T peek() {
        Node node = (Node)this.nodes.get();
        return null != node ? (T)node.element : null;
    }

    @Nullable
    public T peekOrElse(@CheckForNull T t2) {
        Node node = (Node)this.nodes.get();
        return null != node ? node.element : t2;
    }

    @Nullable
    public T push(@CheckForNull T t2) {
        Node node = (Node)this.nodes.get();
        Node<T> node2 = new Node<T>(node, t2);
        this.nodes.set(node2);
        return t2;
    }

    @Nullable
    public T pop() {
        Node node = (Node)this.nodes.get();
        if (null == node) {
            throw new NoSuchElementException();
        }
        if (!Thread.currentThread().equals(node.get())) {
            throw new NoSuchElementException();
        }
        this.nodes.set(node.previous);
        return node.element;
    }

    public void popIf(@CheckForNull T t2) {
        try {
            T t3 = this.pop();
            if (t3 != t2) {
                this.push(t3);
                throw new IllegalStateException(t3 + " (expected " + t2 + " as the top element of the inheritable thread local stack)");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("The inheritable thread local stack is empty!", noSuchElementException);
        }
    }

    private static class Node<T>
    extends WeakReference<Thread> {
        @CheckForNull
        final Node<T> previous;
        @CheckForNull
        T element;

        Node(@CheckForNull Node<T> node, @CheckForNull T t2) {
            super(Thread.currentThread());
            this.previous = node;
            this.element = t2;
        }
    }
}

