/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.util.JointEnumeration;
import zz.de.schlichtherle.truezip.util.JointIterator;

@ThreadSafe
public final class ServiceLocator {
    private final ClassLoader l1;

    public ServiceLocator() {
        this(null);
    }

    public ServiceLocator(@CheckForNull ClassLoader classLoader) {
        this.l1 = null != classLoader ? classLoader : ClassLoader.getSystemClassLoader();
    }

    public <S> Iterator<S> getServices(Class<S> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.l1 == classLoader ? ServiceLoader.load(clazz, this.l1).iterator() : new JointIterator<S>(ServiceLoader.load(clazz, this.l1).iterator(), ServiceLoader.load(clazz, classLoader).iterator());
    }

    @Nullable
    public <S> S getService(Class<S> clazz, @CheckForNull Class<? extends S> clazz2) {
        String string = System.getProperty(clazz.getName(), null == clazz2 ? null : clazz2.getName());
        if (null == string) {
            return null;
        }
        try {
            return clazz2.cast(this.getClass(string).newInstance());
        }
        catch (ClassCastException classCastException) {
            throw new ServiceConfigurationError(classCastException.toString(), classCastException);
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceConfigurationError(instantiationException.toString(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceConfigurationError(illegalAccessException.toString(), illegalAccessException);
        }
    }

    public Class<?> getClass(String string) {
        try {
            return this.l1.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (this.l1 == classLoader) {
                    throw classNotFoundException;
                }
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ServiceConfigurationError(classNotFoundException2.toString(), classNotFoundException2);
            }
        }
    }

    public Enumeration<URL> getResources(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return this.l1 == classLoader ? this.l1.getResources(string) : new JointEnumeration<URL>(this.l1.getResources(string), classLoader.getResources(string));
        }
        catch (IOException iOException) {
            throw new ServiceConfigurationError(iOException.toString(), iOException);
        }
    }

    @CheckForNull
    public static <T> T promote(@CheckForNull Object clazz, Class<T> clazz2) {
        try {
            if (clazz instanceof String && !clazz2.equals(String.class)) {
                clazz = new ServiceLocator(clazz2.getClassLoader()).getClass((String)((Object)clazz));
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new IllegalArgumentException(serviceConfigurationError);
        }
        try {
            if (clazz instanceof Class && !clazz2.equals(Class.class)) {
                clazz = ((Class)clazz).newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        try {
            return clazz2.cast(clazz);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    static {
        Logger.getLogger(ServiceLocator.class.getName(), ServiceLocator.class.getName()).config("banner");
    }
}

