/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import zz.de.schlichtherle.truezip.util.CanonicalStringSet;

public final class SuffixSet
extends CanonicalStringSet {
    public static final char SEPARATOR = '|';
    public static final char PREFIX = '.';

    public SuffixSet() {
        super(new SuffixMapper(), '|');
    }

    public SuffixSet(String string) {
        super(new SuffixMapper(), '|');
        super.addAll(string);
    }

    public SuffixSet(Collection<String> collection) {
        super(new SuffixMapper(), '|');
        super.addAll(collection);
    }

    public Pattern toPattern() {
        Iterator<String> iterator = this.iterator();
        if (iterator.hasNext()) {
            StringBuilder stringBuilder = new StringBuilder(".*\\.(?i)(");
            int n2 = 0;
            do {
                String string = iterator.next();
                if (0 < n2++) {
                    stringBuilder.append('|');
                }
                stringBuilder.append("\\Q").append(string).append("\\E");
            } while (iterator.hasNext());
            assert (0 < n2);
            return Pattern.compile(stringBuilder.append(")[\\").append(File.separatorChar).append("/]*").toString());
        }
        return Pattern.compile("\\00");
    }

    private static class SuffixMapper
    implements CanonicalStringSet.Canonicalizer {
        private SuffixMapper() {
        }

        @Override
        public String map(Object object) {
            String string = object.toString();
            while (0 < string.length() && string.charAt(0) == '.') {
                string = string.substring(1);
            }
            return string.toLowerCase(Locale.ROOT);
        }
    }
}

