/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import zz.de.schlichtherle.truezip.util.UriEncoder;

@NotThreadSafe
public final class UriBuilder {
    private final UriEncoder encoder;
    @CheckForNull
    private StringBuilder builder;
    @CheckForNull
    private String scheme;
    @CheckForNull
    private String authority;
    @CheckForNull
    private String path;
    @CheckForNull
    private String query;
    @CheckForNull
    private String fragment;

    public UriBuilder() {
        this(false);
    }

    public UriBuilder(boolean bl2) {
        this.encoder = new UriEncoder(null, bl2);
    }

    public UriBuilder(URI uRI) {
        this(uRI, false);
    }

    public UriBuilder(URI uRI, boolean bl2) {
        this.encoder = new UriEncoder(null, bl2);
        this.setUri(uRI);
    }

    public UriBuilder clear() {
        this.scheme = null;
        this.authority = null;
        this.path = null;
        this.query = null;
        this.fragment = null;
        return this;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public String getString() throws URISyntaxException {
        boolean bl2;
        boolean bl3;
        StringBuilder stringBuilder = this.resetBuilder();
        int n2 = -1;
        String string = null;
        String string2 = this.scheme;
        String string3 = this.authority;
        String string4 = this.path;
        String string5 = this.query;
        String string6 = this.fragment;
        boolean bl4 = bl3 = null != string2;
        if (bl3) {
            stringBuilder.append(string2).append(':');
        }
        int n3 = stringBuilder.length();
        boolean bl5 = bl2 = null != string3;
        if (bl2) {
            this.encoder.encode(string3, UriEncoder.Encoding.AUTHORITY, stringBuilder.append("//"));
        }
        boolean bl6 = false;
        if (null != string4 && !string4.isEmpty()) {
            if (string4.startsWith("/")) {
                bl6 = true;
                this.encoder.encode(string4, UriEncoder.Encoding.ABSOLUTE_PATH, stringBuilder);
            } else if (bl2) {
                bl6 = true;
                n2 = stringBuilder.length();
                string = "Relative path with " + (string3.isEmpty() ? "" : "non-") + "empty authority";
                this.encoder.encode(string4, UriEncoder.Encoding.ABSOLUTE_PATH, stringBuilder);
            } else if (bl3) {
                this.encoder.encode(string4, UriEncoder.Encoding.QUERY, stringBuilder);
            } else {
                this.encoder.encode(string4, UriEncoder.Encoding.PATH, stringBuilder);
            }
        }
        if (null != string5) {
            stringBuilder.append('?');
            if (bl3 && !bl6) {
                n2 = stringBuilder.length();
                string = "Query in opaque URI";
            }
            this.encoder.encode(string5, UriEncoder.Encoding.QUERY, stringBuilder);
        }
        assert (bl3 == 0 < n3);
        if (bl3 && n3 >= stringBuilder.length()) {
            n2 = stringBuilder.length();
            string = "Empty scheme specific part in absolute URI";
        }
        if (null != string6) {
            this.encoder.encode(string6, UriEncoder.Encoding.FRAGMENT, stringBuilder.append('#'));
        }
        if (bl3) {
            UriBuilder.validateScheme((CharBuffer)CharBuffer.wrap(stringBuilder).limit(string2.length()));
        }
        String string7 = stringBuilder.toString();
        if (0 <= n2) {
            throw new QuotedUriSyntaxException((Object)string7, string, n2);
        }
        return string7;
    }

    private StringBuilder resetBuilder() {
        StringBuilder stringBuilder = this.builder;
        if (null == stringBuilder) {
            this.builder = stringBuilder = new StringBuilder();
        } else {
            stringBuilder.setLength(0);
        }
        return stringBuilder;
    }

    public static void validateScheme(String string) throws URISyntaxException {
        UriBuilder.validateScheme(CharBuffer.wrap(string));
    }

    private static void validateScheme(CharBuffer charBuffer) throws URISyntaxException {
        if (!charBuffer.hasRemaining()) {
            throw UriBuilder.newURISyntaxException(charBuffer, "Empty URI scheme");
        }
        char c2 = charBuffer.get();
        if (!(c2 >= 'a' && 'z' >= c2 || c2 >= 'A' && 'Z' >= c2)) {
            throw UriBuilder.newURISyntaxException(charBuffer, "Illegal character in URI scheme");
        }
        while (charBuffer.hasRemaining()) {
            c2 = charBuffer.get();
            if (c2 >= 'a' && 'z' >= c2 || c2 >= 'A' && 'Z' >= c2 || c2 >= '0' && '9' >= c2 || c2 == '+' || c2 == '-' || c2 == '.') continue;
            throw UriBuilder.newURISyntaxException(charBuffer, "Illegal character in URI scheme");
        }
    }

    private static URISyntaxException newURISyntaxException(CharBuffer charBuffer, String string) {
        int n2 = charBuffer.position() - 1;
        return new QuotedUriSyntaxException(charBuffer.rewind().limit(charBuffer.capacity()), string, n2);
    }

    public void setString(String string) {
        this.setUri(URI.create(string));
    }

    public UriBuilder string(String string) {
        this.setString(string);
        return this;
    }

    public URI toUri() {
        try {
            return this.getUri();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public URI getUri() throws URISyntaxException {
        String string = this.getString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    public void setUri(URI uRI) {
        if (this.encoder.isRaw()) {
            this.setScheme(uRI.getScheme());
            this.setAuthority(uRI.getRawAuthority());
            this.setPath(uRI.isOpaque() ? uRI.getRawSchemeSpecificPart() : uRI.getRawPath());
            this.setQuery(uRI.getRawQuery());
            this.setFragment(uRI.getRawFragment());
        } else {
            this.setScheme(uRI.getScheme());
            this.setAuthority(uRI.getAuthority());
            this.setPath(uRI.isOpaque() ? uRI.getSchemeSpecificPart() : uRI.getPath());
            this.setQuery(uRI.getQuery());
            this.setFragment(uRI.getFragment());
        }
    }

    public UriBuilder uri(URI uRI) {
        this.setUri(uRI);
        return this;
    }

    @CheckForNull
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(@CheckForNull String string) {
        this.scheme = string;
    }

    public UriBuilder scheme(@CheckForNull String string) {
        this.setScheme(string);
        return this;
    }

    @CheckForNull
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(@CheckForNull String string) {
        this.authority = string;
    }

    public UriBuilder authority(@CheckForNull String string) {
        this.setAuthority(string);
        return this;
    }

    @CheckForNull
    public String getPath() {
        return this.path;
    }

    public void setPath(@CheckForNull String string) {
        this.path = string;
    }

    public UriBuilder path(@CheckForNull String string) {
        this.setPath(string);
        return this;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@CheckForNull String string) {
        this.query = string;
    }

    public UriBuilder query(@CheckForNull String string) {
        this.setQuery(string);
        return this;
    }

    public void setPathQuery(@CheckForNull String string) {
        int n2;
        if (null != string && 0 <= (n2 = string.indexOf(63))) {
            this.path = string.substring(0, n2);
            this.query = string.substring(n2 + 1);
        } else {
            this.path = string;
            this.query = null;
        }
    }

    public UriBuilder pathQuery(@CheckForNull String string) {
        this.setPathQuery(string);
        return this;
    }

    @CheckForNull
    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(@CheckForNull String string) {
        this.fragment = string;
    }

    public UriBuilder fragment(@CheckForNull String string) {
        this.setFragment(string);
        return this;
    }
}

